/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class ListObjectsV2Request
extends Ks3WebServiceRequest {
    private String bucket;
    private String prefix;
    private String continuationToken;
    private String delimiter;
    private Integer maxKeys;
    private String encodingType;
    private Boolean fetchOwner;
    private String startAfter;

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public ListObjectsV2Request(String bucketName) {
        this(bucketName, null, null, null, null, null, null);
    }

    public ListObjectsV2Request(String bucketName, String prefix) {
        this(bucketName, prefix, null, null, null, null, null);
    }

    public ListObjectsV2Request(String bucketName, String prefix, String continuationToken, String delimiter, Integer maxKeys, Boolean fetchOwner, String startAfter) {
        this.bucket = bucketName;
        this.prefix = prefix;
        this.continuationToken = continuationToken;
        this.delimiter = delimiter;
        this.maxKeys = maxKeys;
        this.fetchOwner = fetchOwner;
        this.startAfter = startAfter;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.maxKeys != null && (this.maxKeys > 1000 || this.maxKeys < 1)) {
            throw ClientIllegalArgumentExceptionGenerator.between("maxKeys", String.valueOf(this.maxKeys), "1", "1000");
        }
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(this.bucket);
        request.addQueryParam("list-type", "2");
        request.addQueryParamIfNotNull("prefix", this.prefix);
        request.addQueryParamIfNotNull("continuation-token", this.continuationToken);
        request.addQueryParamIfNotNull("delimiter", this.delimiter);
        request.addQueryParamIfNotNull("start-after", this.startAfter);
        if (this.fetchOwner != null) {
            request.addQueryParamIfNotNull("fetch-owner", String.valueOf(this.fetchOwner));
        }
        if (this.maxKeys != null) {
            request.addQueryParamIfNotNull("max-keys", String.valueOf(this.maxKeys));
        }
        request.addQueryParamIfNotNull("encoding-type", this.encodingType);
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public Boolean getFetchOwner() {
        return this.fetchOwner;
    }

    public void setFetchOwner(Boolean fetchOwner) {
        this.fetchOwner = fetchOwner;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public void setStartAfter(String startAfter) {
        this.startAfter = startAfter;
    }
}

