/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public class PutBucketPolicyRequest
extends Ks3WebServiceRequest {
    private String bucketName;
    private String policyText;

    public PutBucketPolicyRequest() {
    }

    public PutBucketPolicyRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public PutBucketPolicyRequest(String bucketName, String policyText) {
        this.bucketName = bucketName;
        this.policyText = policyText;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPolicyText() {
        return this.policyText;
    }

    public void setPolicyText(String policyText) {
        this.policyText = policyText;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucketName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (StringUtils.isBlank(this.policyText)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketPolicyText");
        }
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucketName);
        request.setContent(new ByteArrayInputStream(this.policyText.getBytes(StandardCharsets.UTF_8)));
        request.addQueryParam("policy", "");
    }
}

