/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.ReplicationRule;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;

public class PutBucketReplicationConfigurationRequest
extends Ks3WebServiceRequest {
    private String bucketName;
    private ReplicationRule replicationRule;

    public PutBucketReplicationConfigurationRequest() {
    }

    public PutBucketReplicationConfigurationRequest(String bucketName, ReplicationRule replicationRule) {
        this.bucketName = bucketName;
        this.replicationRule = replicationRule;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public ReplicationRule getReplicationRule() {
        return this.replicationRule;
    }

    public void setReplicationRule(ReplicationRule replicationRule) {
        this.replicationRule = replicationRule;
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.replicationRule == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("replicationRule");
        }
        if (this.replicationRule.getTargetBucket() == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("targetBucket");
        }
        if (this.replicationRule.getPrefixList().size() > 5) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("prefixList", this.replicationRule.getPrefixList().toString(), "prefixList too many");
        }
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucketName);
        request.addQueryParam("crr", "");
        XmlWriter writer = new XmlWriter();
        writer.startWithNs("Replication");
        for (String prefix : this.replicationRule.getPrefixList()) {
            writer.start("prefix").value(prefix).end();
        }
        if (this.replicationRule.isDeleteMarkerStatus()) {
            writer.start("DeleteMarkerStatus").value("Enabled").end();
        } else {
            writer.start("DeleteMarkerStatus").value("Disabled").end();
        }
        Boolean historicalObjectReplication = this.replicationRule.getHistoricalObjectReplication();
        if (historicalObjectReplication != null) {
            writer.start("HistoricalObjectReplication").value(historicalObjectReplication != false ? "Enabled" : "Disabled").end();
        }
        writer.start("targetBucket").value(this.replicationRule.getTargetBucket()).end();
        writer.end();
        String xml = writer.toString();
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }
}

