/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;

public class PutObjectACLRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private AccessControlList accessControlList;
    private CannedAccessControlList cannedAcl;

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (this.accessControlList == null && this.cannedAcl == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("accessControlList", "cannedAcl");
        }
    }

    public PutObjectACLRequest(String bucketName, String objectName) {
        this.bucket = bucketName;
        this.key = objectName;
    }

    public PutObjectACLRequest(String bucketName, String objectName, AccessControlList accessControlList) {
        this(bucketName, objectName);
        this.setAccessControlList(accessControlList);
    }

    public PutObjectACLRequest(String bucketName, String objectName, CannedAccessControlList cannedAcl) {
        this(bucketName, objectName);
        this.setCannedAcl(cannedAcl);
    }

    public PutObjectACLRequest(String bucketName, String objectName, AccessControlList accessControlList, CannedAccessControlList cannedAcl) {
        this(bucketName, objectName);
        this.setAccessControlList(accessControlList);
        this.setCannedAcl(cannedAcl);
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam("acl", "");
        if (this.getCannedAcl() != null) {
            request.addHeader(HttpHeaders.CannedAcl, this.getCannedAcl().toString());
        }
        if (this.accessControlList != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.accessControlList));
        }
    }
}

