/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.Jackson;
import com.ksyun.ks3.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PutObjectFetchRequest
extends Ks3WebServiceRequest {
    private static final Log log = LogFactory.getLog(PutObjectFetchRequest.class);
    private String bucket;
    private String key;
    private ObjectMetadata objectMeta = new ObjectMetadata();
    private CannedAccessControlList cannedAcl;
    private AccessControlList acl = new AccessControlList();
    private String sourceUrl;
    private String callbackUrl;
    private boolean force;
    private String fetchSourceHeader;

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getFetchSourceHeader() {
        return this.fetchSourceHeader;
    }

    public void setFetchSourceHeader(String fetchSourceHeader) {
        this.fetchSourceHeader = fetchSourceHeader;
    }

    public PutObjectFetchRequest(String bucketname, String key, String sourceUrl) {
        this.bucket = bucketname;
        this.key = key;
        this.sourceUrl = sourceUrl;
    }

    public PutObjectFetchRequest(String bucketname, String key, ObjectMetadata metadata) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.bucket = bucketname;
        this.key = key;
        this.setObjectMeta(metadata);
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (StringUtils.isBlank(this.sourceUrl)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceUrl");
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setMd5Base64(String md5Base64) {
        this.objectMeta.setContentMD5(md5Base64);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ObjectMetadata getObjectMeta() {
        return this.objectMeta;
    }

    public void setObjectMeta(ObjectMetadata objectMeta) {
        this.objectMeta = objectMeta;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam("fetch", "");
        if (this.objectMeta == null) {
            this.objectMeta = new ObjectMetadata();
        }
        request.getHeaders().putAll(HttpUtils.convertMeta2Headers(this.objectMeta));
        if (this.cannedAcl != null) {
            request.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.acl));
        }
        try {
            if (this.sourceUrl != null) {
                request.getHeaders().put(HttpHeaders.XKssSourceUrl.toString(), URLEncoder.encode(this.sourceUrl, "UTF-8"));
            }
            if (this.callbackUrl != null) {
                request.getHeaders().put(HttpHeaders.XKssCallbackUrl.toString(), URLEncoder.encode(this.callbackUrl, "UTF-8"));
            }
            if (this.isForce()) {
                request.getHeaders().put(HttpHeaders.XKssForce.toString(), String.valueOf(this.force));
            }
            if (this.fetchSourceHeader != null) {
                Map map = Jackson.fromJsonString(this.fetchSourceHeader, Map.class);
                request.getHeaders().put(HttpHeaders.XKssFetchSourceHeader.toString(), this.fetchSourceHeader);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"put head error:{}", (Throwable)e);
        }
    }
}

