/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.ObjectTag;
import com.ksyun.ks3.dto.ObjectTagging;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class PutObjectTaggingRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private ObjectTagging tagging;
    private Pattern TAG_PATTERN = Pattern.compile("^[\\w\\-+=.:/][\\w\\-+=.:/\\s]*(?<!\\s)$");

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ObjectTagging getObjectTagging() {
        return this.tagging;
    }

    public void setObjectTagging(ObjectTagging tagging) {
        this.tagging = tagging;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (this.tagging == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectTagging");
        }
        if (this.tagging.getTagSet() == null || this.tagging.getTagSet().size() == 0) {
            throw ClientIllegalArgumentExceptionGenerator.between("tagset", "0", "1", "10");
        }
        if (this.tagging.getTagSet().size() > 10) {
            throw ClientIllegalArgumentExceptionGenerator.between("tagset", "" + this.tagging.getTagSet().size(), "1", "10");
        }
        ArrayList<String> tagKeys = new ArrayList<String>();
        for (ObjectTag tag : this.tagging.getTagSet()) {
            if (!this.TAG_PATTERN.matcher(tag.getKey()).matches()) {
                throw ClientIllegalArgumentExceptionGenerator.notCorrect("key", tag.getKey(), "invalid key format");
            }
            if (tag.getValue() != null && !this.TAG_PATTERN.matcher(tag.getValue()).matches()) {
                throw ClientIllegalArgumentExceptionGenerator.notCorrect("value", tag.getValue(), "invalid value format");
            }
            if (tag.getKey().getBytes(StandardCharsets.UTF_8).length > 128) {
                throw ClientIllegalArgumentExceptionGenerator.notCorrect("key", tag.getKey(), "invalid length");
            }
            if (tag.getValue() != null && tag.getValue().getBytes(StandardCharsets.UTF_8).length > 256) {
                throw ClientIllegalArgumentExceptionGenerator.notCorrect("value", tag.getValue(), "invalid length");
            }
            if (!tagKeys.contains(tag.getKey())) {
                tagKeys.add(tag.getKey());
                continue;
            }
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("key", tag.getKey(), "duplicated tagging key");
        }
    }

    public PutObjectTaggingRequest(String bucketName, String objectName) {
        this.bucket = bucketName;
        this.key = objectName;
    }

    public PutObjectTaggingRequest(String bucketName, String objectName, ObjectTagging objectTagging) {
        this(bucketName, objectName);
        this.setObjectTagging(objectTagging);
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam("tagging", "");
        XmlWriter writer = new XmlWriter();
        writer.start("Tagging");
        writer.start("TagSet");
        List<ObjectTag> tags = this.tagging.getTagSet();
        for (ObjectTag tag : tags) {
            writer.start("Tag");
            writer.start("Key").value(tag.getKey()).end();
            if (tag.getValue() != null) {
                writer.start("Value").value(tag.getValue()).end();
            }
            writer.end();
        }
        writer.end();
        writer.end();
        String xml = writer.toString();
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }
}

