/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.service.request.RestoreTier;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public class RestoreObjectRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private int expirationInDays = 1;
    private RestoreTier tier;

    public RestoreObjectRequest(String bucketName, String objectKey) {
        this.bucket = bucketName;
        this.key = objectKey;
    }

    public RestoreObjectRequest(String bucketName, String objectKey, int expirationInDays) {
        this.bucket = bucketName;
        this.key = objectKey;
        this.expirationInDays = expirationInDays;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.POST);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam("restore", "");
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.startWithNs("RestoreRequest");
        xmlWriter.start("Days").value(this.getExpirationInDays()).end();
        xmlWriter.start("JobParameters");
        if (this.getTier() != null) {
            xmlWriter.start("Tier").value(this.getTier().getValue()).end();
        }
        xmlWriter.end();
        xmlWriter.end();
        String xml = xmlWriter.toString();
        byte[] content = xml.getBytes(StandardCharsets.UTF_8);
        request.setContent(new ByteArrayInputStream(content));
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.addHeader(HttpHeaders.ContentLength, String.valueOf(content.length));
        request.addHeader(HttpHeaders.ContentType, "application/xml");
    }

    public int getExpirationInDays() {
        return this.expirationInDays;
    }

    public void setExpirationInDays(int expirationInDays) {
        this.expirationInDays = expirationInDays;
    }

    public RestoreTier getTier() {
        return this.tier;
    }

    public void setTier(RestoreTier tier) {
        this.tier = tier;
    }
}

