/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.BucketLifecycleConfiguration;
import com.ksyun.ks3.dto.ObjectTag;
import com.ksyun.ks3.service.response.Ks3WebServiceXmlResponse;
import com.ksyun.ks3.utils.DateUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GetBucketLifecycleResponse
extends Ks3WebServiceXmlResponse<BucketLifecycleConfiguration> {
    private BucketLifecycleConfiguration.Rule rule = null;
    private final List<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
    private List<BucketLifecycleConfiguration.Transition> storageTransList;
    private BucketLifecycleConfiguration.Transition transition = null;
    private List<ObjectTag> tagSet;
    private ObjectTag tagging;
    private BucketLifecycleConfiguration.AbortMultipartUpload abortMultipartUpload = null;

    @Override
    public void startDocument() throws SAXException {
        this.result = new BucketLifecycleConfiguration();
    }

    @Override
    public void startEle(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag = this.getTag();
        if ("Rule".equals(tag)) {
            this.rule = new BucketLifecycleConfiguration.Rule();
            this.storageTransList = new ArrayList<BucketLifecycleConfiguration.Transition>();
            this.tagSet = new ArrayList<ObjectTag>();
        } else if ("Transition".equals(tag)) {
            this.transition = new BucketLifecycleConfiguration.Transition();
        } else if ("Tag".equals(tag)) {
            this.tagging = new ObjectTag();
        } else if ("AbortIncompleteMultipartUpload".equals(tag)) {
            this.abortMultipartUpload = new BucketLifecycleConfiguration.AbortMultipartUpload();
        }
    }

    @Override
    public void endEle(String uri, String localName, String qName) throws SAXException {
        String tag = this.getTag();
        if ("Rule".equals(tag)) {
            if (this.storageTransList != null && !this.storageTransList.isEmpty()) {
                this.rule.setStorageTransitions(this.storageTransList);
            }
            if (this.tagSet != null && !this.tagSet.isEmpty()) {
                this.rule.setTagSet(this.tagSet);
            }
            this.rules.add(this.rule);
        } else if ("LifecycleConfiguration".equals(tag)) {
            ((BucketLifecycleConfiguration)this.result).setRules(this.rules);
        } else if ("Transition".equals(tag)) {
            this.storageTransList.add(this.transition);
        } else if ("Tag".equals(tag)) {
            if (this.tagSet != null) {
                this.tagSet.add(this.tagging);
            }
        } else if ("AbortIncompleteMultipartUpload".equals(tag)) {
            this.rule.setAbortMultipartUpload(this.abortMultipartUpload);
        }
    }

    @Override
    public void string(String s) {
        String tag = this.getTag();
        if ("ID".equals(tag)) {
            this.rule.setId(s);
        } else if ("Prefix".equals(tag)) {
            this.rule.setPrefix(s);
        } else if ("Status".equals(tag)) {
            this.rule.setStatus(BucketLifecycleConfiguration.Status.str2Status(s));
        } else if ("Expiration".equals(this.getTag(1))) {
            if ("Date".equals(tag)) {
                this.rule.setExpirationDate(DateUtils.convertStr2Date(s));
            } else if ("Days".equals(tag)) {
                this.rule.setExpirationInDays(Integer.valueOf(s));
            }
        } else if ("Transition".equals(this.getTag(1))) {
            if ("Date".equals(tag)) {
                this.transition.setTransDate(DateUtils.convertStr2Date(s));
            } else if ("Days".equals(tag)) {
                this.transition.setTransDays(Integer.valueOf(s));
            } else if ("StorageClass".equals(tag)) {
                this.transition.setStorageClass(s);
            }
        } else if ("Tag".equals(this.getTag(1))) {
            if ("Key".equals(tag)) {
                this.tagging.setKey(s);
            } else if ("Value".equals(tag)) {
                this.tagging.setValue(s);
            }
        } else if ("AbortIncompleteMultipartUpload".equals(this.getTag(1))) {
            if ("Date".equals(tag)) {
                this.abortMultipartUpload.setCreatedBeforeDate(DateUtils.convertStr2Date(s));
            } else if ("DaysAfterInitiation".equals(tag)) {
                this.abortMultipartUpload.setExpirationDays(Integer.parseInt(s));
            }
        }
    }

    @Override
    public void preHandle() {
    }

    @Override
    public int[] expectedStatus() {
        return new int[]{200};
    }
}

