/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.service.response.Ks3WebServiceResponse;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Ks3WebServiceXmlResponse<T>
extends Ks3WebServiceResponse<T> {
    protected T result;
    private String buffer = "";
    private List<String> preTags = new ArrayList<String>();

    protected String getTag(int i) {
        if (i < this.preTags.size()) {
            return this.preTags.get(this.preTags.size() - 1 - i);
        }
        return null;
    }

    protected String getTag() {
        return this.getTag(0);
    }

    @Override
    protected T abstractHandleResponse() {
        this.preHandle();
        InputStream in = null;
        try {
            in = super.getHttpResponse().getEntity().getContent();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)this);
            return this.result;
        }
        catch (Exception e) {
            throw new Ks3ClientException("\u5904\u7406http response\u65f6\u51fa\u9519", e);
        }
    }

    public abstract void preHandle();

    @Override
    public abstract void startDocument() throws SAXException;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.string(this.buffer);
        this.buffer = "";
        if (qName.startsWith("ns2:")) {
            qName = qName.substring(4);
        }
        this.preTags.add(qName);
        this.startEle(uri, localName, qName, attributes);
    }

    public abstract void startEle(String var1, String var2, String var3, Attributes var4) throws SAXException;

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.buffer.startsWith("<![CDATA[") && this.buffer.endsWith("]]>")) {
            this.buffer = this.buffer.substring("<![CDATA[".length());
            this.buffer = this.buffer.substring(0, this.buffer.length() - "]]>".length());
        }
        this.string(this.buffer);
        this.buffer = "";
        if (qName.startsWith("ns2:")) {
            qName = qName.substring(4);
        }
        this.endEle(uri, localName, qName);
        if (this.preTags.get(this.preTags.size() - 1).equals(qName)) {
            this.preTags.remove(this.preTags.size() - 1);
        }
    }

    public abstract void endEle(String var1, String var2, String var3) throws SAXException;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.getTag() != null) {
            String content = new String(ch, start, length);
            this.buffer = this.buffer + content;
        }
    }

    public abstract void string(String var1);
}

