/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.transfer;

import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.exception.serviceside.NotFoundException;
import com.ksyun.ks3.service.Ks3;
import com.ksyun.ks3.service.encryption.Ks3EncryptionClient;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import com.ksyun.ks3.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ks3UploadClient {
    private CannedAccessControlList acl;
    private int multipartMaxThread;
    private int batchUploadThread;
    private int batchCheckThread;
    private boolean isEncryptionClient = false;
    private static final Log log = LogFactory.getLog(Ks3UploadClient.class);
    Ks3 client = null;

    public Ks3UploadClient(Ks3 client) {
        this(client, 5, 10, 30, CannedAccessControlList.Private);
    }

    public Ks3UploadClient(Ks3 client, int multipartMaxThread, int batchUploadThread, int batchCheckThread) {
        this(client, multipartMaxThread, batchUploadThread, batchCheckThread, CannedAccessControlList.Private);
    }

    public Ks3UploadClient(Ks3 client, CannedAccessControlList acl) {
        this(client, 5, 10, 30, acl);
    }

    public Ks3UploadClient(Ks3 client, int multipartMaxThread, int batchUploadThread, int batchCheckThread, CannedAccessControlList acl) {
        this.client = client;
        this.multipartMaxThread = multipartMaxThread;
        this.batchUploadThread = batchUploadThread;
        this.batchCheckThread = batchCheckThread;
        this.acl = acl;
        if (client instanceof Ks3EncryptionClient) {
            this.isEncryptionClient = true;
        }
    }

    public CannedAccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(CannedAccessControlList acl) {
        this.acl = acl;
    }

    public int getMultipartMaxThread() {
        return this.multipartMaxThread;
    }

    public void setMultipartMaxThread(int multipartMaxThread) {
        this.multipartMaxThread = multipartMaxThread;
    }

    public int getBatchUploadThread() {
        return this.batchUploadThread;
    }

    public void setBatchUploadThread(int batchUploadThread) {
        this.batchUploadThread = batchUploadThread;
    }

    public int getBatchCheckThread() {
        return this.batchCheckThread;
    }

    public void setBatchCheckThread(int batchCheckThread) {
        this.batchCheckThread = batchCheckThread;
    }

    public Ks3 getClient() {
        return this.client;
    }

    public void setClient(Ks3 client) {
        this.client = client;
    }

    public void uploadFile(String bucket, String key, File file) {
        log.debug((Object)String.format("UPLOAD_FILE:upload file %s to bucket %s key %s ", file.getAbsolutePath(), bucket, key));
        long length = file.length();
        if (length <= 102400L) {
            PutObjectRequest request = new PutObjectRequest(bucket, key, file);
            request.setCannedAcl(this.acl);
            this.client.putObject(request);
        } else if (this.isEncryptionClient) {
            this.mutipartUpload(bucket, key, file);
        } else {
            this.mutipartUploadByThreads(bucket, key, file);
        }
    }

    public Map<String, File> uploadDir(String bucket, String destDir, File sourceDir) {
        return this.uploadDir(bucket, destDir, sourceDir, false);
    }

    public Map<String, File> uploadDir(String bucket, String destDir, File sourceDir, boolean check) {
        int maxTry = 3;
        ConcurrentHashMap<String, File> toUpload = new ConcurrentHashMap<String, File>();
        this.generate(toUpload, destDir, sourceDir);
        Map<String, File> error = toUpload;
        int i = 0;
        do {
            log.debug((Object)("UPLOAD_DIR_BATCH_START:batch upload rand " + i + ",bucket " + bucket + ",destDir " + destDir + ",sourceDir " + sourceDir + ",count:" + error.size()));
            error = this.batchUpload(bucket, error, check);
            log.debug((Object)("UPLOAD_DIR_BATCH_END:batch upload rand " + i + ",bucket " + bucket + ",destDir " + destDir + ",sourceDir " + sourceDir + ",count:" + error.size()));
        } while (error.size() > 0 && ++i < maxTry);
        return error;
    }

    private void generate(Map<String, File> toUpload, String destDir, File sourceDir) {
        if (destDir == null) {
            destDir = "";
        }
        if (!StringUtils.isBlank(destDir) && !destDir.endsWith("/")) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("destDir", destDir, "ends with /");
        }
        String baseKey = destDir + StringUtils.getFileName(sourceDir);
        if (sourceDir.isDirectory()) {
            File[] files = sourceDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.generate(toUpload, baseKey + "/", file);
                        continue;
                    }
                    String key = baseKey + "/" + StringUtils.getFileName(file);
                    if (StringUtils.isBlank(baseKey)) {
                        key = StringUtils.getFileName(file);
                    }
                    log.debug((Object)("found key :" + key));
                    toUpload.put(key, file);
                }
            }
        } else {
            log.debug((Object)("found key :" + baseKey));
            toUpload.put(baseKey, sourceDir);
        }
    }

    public Map<String, File> batchUpload(String bucket, Map<String, File> files) {
        return this.batchUpload(bucket, files, false, this.batchUploadThread);
    }

    public Map<String, File> batchUpload(String bucket, Map<String, File> files, boolean check) {
        return this.batchUpload(bucket, files, check, this.batchUploadThread);
    }

    public Map<String, File> batchUpload(String bucket, Map<String, File> files, int maxThreads) {
        return this.batchUpload(bucket, files, false, this.batchUploadThread);
    }

    public Map<String, File> batchUpload(final String bucket, Map<String, File> files, final boolean check, int maxThreads) {
        int total = files.size();
        if (total < maxThreads) {
            maxThreads = total;
        }
        final ConcurrentHashMap<String, File> faild = new ConcurrentHashMap<String, File>();
        if (total == 0) {
            return faild;
        }
        ExecutorService pool = Executors.newFixedThreadPool(maxThreads);
        for (final Map.Entry<String, File> enrty : files.entrySet()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    boolean exists = false;
                    if (check) {
                        try {
                            Ks3UploadClient.this.client.headObject(bucket, (String)enrty.getKey());
                            exists = true;
                        }
                        catch (Exception e) {
                            exists = false;
                        }
                    }
                    if (!exists) {
                        try {
                            Ks3UploadClient.this.uploadFile(bucket, (String)enrty.getKey(), (File)enrty.getValue());
                        }
                        catch (Exception e) {
                            log.error((Object)String.format("UPLOAD_FILE_ERROR:upload file %s to bucket %s key %s error %s", ((File)enrty.getValue()).getAbsolutePath(), bucket, enrty.getKey(), e));
                            faild.put(enrty.getKey(), enrty.getValue());
                        }
                    } else {
                        log.debug((Object)String.format("UPLOAD_FILE_SKIPPED:upload file %s to bucket %s key %s skipped as it exists", ((File)enrty.getValue()).getAbsolutePath(), bucket, enrty.getKey()));
                    }
                }
            };
            pool.execute(t);
        }
        pool.shutdown();
        while (!pool.isTerminated()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return faild;
    }

    public List<String> batchCheck(String bucket, List<String> keys) {
        return this.batchCheck(bucket, keys, this.batchCheckThread);
    }

    public List<String> batchCheck(final String bucket, List<String> keys, int maxThreads) {
        int maxRetry = 3;
        final ArrayList<String> notFound = new ArrayList<String>();
        int total = keys.size();
        if (total < maxThreads) {
            maxThreads = total;
        }
        if (total == 0) {
            return notFound;
        }
        ExecutorService pool = Executors.newFixedThreadPool(maxThreads);
        for (final String key : keys) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    int faild = 0;
                    try {
                        log.debug((Object)String.format("CHECK_EXISTS:check key %s , bucket %s,times %s", key, bucket, faild));
                        Ks3UploadClient.this.client.headObject(bucket, key);
                    }
                    catch (NotFoundException e) {
                        notFound.add(key);
                    }
                    catch (Exception e) {
                        if (++faild <= 3) {
                            this.run();
                        }
                        notFound.add(key);
                    }
                }
            };
            pool.execute(t);
        }
        pool.shutdown();
        while (!pool.isTerminated()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return notFound;
    }

    public List<String> checkDir(String bucket, String destDir, File sourceDir) {
        return this.checkDir(bucket, destDir, sourceDir, this.batchCheckThread);
    }

    public List<String> checkDir(String bucket, String destDir, File sourceDir, int maxThreads) {
        ConcurrentHashMap<String, File> toUpload = new ConcurrentHashMap<String, File>();
        this.generate(toUpload, destDir, sourceDir);
        return this.batchCheck(bucket, new ArrayList<String>(toUpload.keySet()), maxThreads);
    }

    public void mutipartUploadByThreads(String bucket, String key, File file) {
        this.mutipartUploadByThreads(bucket, key, file, this.multipartMaxThread);
    }

    public void mutipartUploadByThreads(String bucket, String key, File file, int maxThreads) {
        int threads;
        long length = file.length();
        long partSize = 0L;
        if (length == 0L) {
            this.client.putObject(bucket, key, file);
        }
        if ((threads = (int)(length / (partSize = length < 0x500000L ? 102400L : 0x500000L)) + (length % partSize == 0L ? 0 : 1)) > maxThreads) {
            threads = maxThreads;
        }
        this.mutipartUploadByThreads(bucket, key, file, partSize, threads);
    }

    public void mutipartUploadByThreads(final String bucket, final String key, final File file, final long partSize, int threads) {
        long length = file.length();
        int maxRetry = 3;
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucket, key);
        request.setCannedAcl(this.acl);
        final InitiateMultipartUploadResult initResult = this.client.initiateMultipartUpload(request);
        final ArrayList<PartETag> partEtags = new ArrayList<PartETag>();
        final int partnums = (int)(length / partSize) + (length % partSize == 0L ? 0 : 1);
        final ExecutorService pool = Executors.newFixedThreadPool(threads);
        final ConcurrentHashMap<String, Boolean> shouldComplete = new ConcurrentHashMap<String, Boolean>();
        shouldComplete.put("flag", true);
        int i = 0;
        while (i < partnums) {
            final int partNum = i++;
            Thread t = new Thread(){
                int failed = 0;

                @Override
                public void run() {
                    try {
                        UploadPartRequest upRequest = new UploadPartRequest(bucket, key, initResult.getUploadId(), partNum + 1, file, partSize, partSize * (long)partNum);
                        if (partNum == partnums - 1) {
                            upRequest.setLastPart(true);
                        }
                        PartETag upResult = Ks3UploadClient.this.client.uploadPart(upRequest);
                        partEtags.add(upResult);
                    }
                    catch (RuntimeException e) {
                        ++this.failed;
                        if (this.failed <= 3) {
                            this.run();
                        }
                        String errorMsg = String.format("MULTIPART_UPLOAD:bucket %s key %s file %s uploadid %s partNumber %s upload fail after %s retrys", bucket, key, file.getAbsolutePath(), initResult.getUploadId(), partNum + 1, 3);
                        log.error((Object)errorMsg);
                        shouldComplete.put("flag", false);
                        shouldComplete.put("cause", e);
                        pool.shutdownNow();
                    }
                }
            };
            if (!((Boolean)shouldComplete.get("flag")).booleanValue()) {
                pool.shutdownNow();
                break;
            }
            pool.execute(t);
        }
        pool.shutdown();
        while (!pool.isTerminated()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!((Boolean)shouldComplete.get("flag")).booleanValue()) {
            this.client.abortMultipartUpload(bucket, key, initResult.getUploadId());
            throw (RuntimeException)shouldComplete.get("cause");
        }
        this.client.completeMultipartUpload(bucket, key, initResult.getUploadId(), partEtags);
    }

    public void mutipartUpload(String bucket, String key, File file) {
        long length = file.length();
        long partSize = 0L;
        if (length == 0L) {
            this.client.putObject(bucket, key, file);
        }
        partSize = length < 0x500000L ? 102400L : 0x500000L;
        this.mutipartUpload(bucket, key, file, partSize);
    }

    public void mutipartUpload(String bucket, String key, File file, long partSize) {
        long length = file.length();
        int maxRetry = 3;
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucket, key);
        request.setCannedAcl(this.acl);
        InitiateMultipartUploadResult initResult = this.client.initiateMultipartUpload(request);
        ArrayList<PartETag> partEtags = new ArrayList<PartETag>();
        int partnums = (int)(length / partSize) + (length % partSize == 0L ? 0 : 1);
        boolean success = true;
        for (int i = 0; i < partnums; ++i) {
            int partNum = i;
            try {
                UploadPartRequest upRequest = new UploadPartRequest(bucket, key, initResult.getUploadId(), partNum + 1, file, partSize, partSize * (long)partNum);
                if (partNum == partnums - 1) {
                    upRequest.setLastPart(true);
                }
                PartETag upResult = this.client.uploadPart(upRequest);
                partEtags.add(upResult);
                continue;
            }
            catch (RuntimeException e) {
                String errorMsg = String.format("MULTIPART_UPLOAD:bucket %s key %s file %s uploadid %s partNumber %s upload fail ", bucket, key, file.getAbsolutePath(), initResult.getUploadId(), partNum + 1, 3);
                log.error((Object)errorMsg);
                success = false;
                this.client.abortMultipartUpload(bucket, key, initResult.getUploadId());
                throw e;
            }
        }
        if (success) {
            this.client.completeMultipartUpload(bucket, key, initResult.getUploadId(), partEtags);
        }
    }
}

