/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.signer;

import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.signer.internal.FIFOCache;
import com.ksyun.ks3.signer.internal.KSSSignerRequestParams;
import com.ksyun.ks3.signer.internal.SdkDigestInputStream;
import com.ksyun.ks3.signer.internal.SignerKey;
import com.ksyun.ks3.utils.AuthUtils;
import com.ksyun.ks3.utils.BinaryUtils;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.SdkUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ks3V4Signer {
    private static final String LINE_SEPARATOR = "\n";
    private static final String KSS4_TERMINATOR = "kss4_request";
    private static final String KSS4_SIGNING_ALGORITHM = "KSS4-HMAC-SHA256";
    private static final String X_Kss_CREDENTIAL = "X-Kss-Credential";
    private static final String X_Kss_DATE = "X-Kss-Date";
    private static final String X_Kss_EXPIRES = "X-Kss-Expires";
    private static final String X_Kss_SIGNED_HEADER = "X-Kss-SignedHeaders";
    private static final String X_Kss_CONTENT_SHA256 = "X-Kss-content-sha256";
    private static final String X_Kss_SIGNATURE = "X-Kss-Signature";
    private static final String X_Kss_ALGORITHM = "X-Kss-Algorithm";
    private static final String AUTHORIZATION = "Authorization";
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final String HOST = "Host";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final int SIGNER_CACHE_MAX_SIZE = 300;
    private static final FIFOCache<SignerKey> signerCache = new FIFOCache(300);
    private static final Log log = LogFactory.getLog(AuthUtils.class);
    private static final List<String> listOfHeadersToIgnoreInLowerCase = Arrays.asList("connection", "x-kss-trace-id");

    public String sign(Authorization auth, Request request, Ks3ClientConfig ks3config) throws SignatureException {
        KSSSignerRequestParams signerParams = new KSSSignerRequestParams(request, new Date(), request.getRegion(), "ks3", KSS4_SIGNING_ALGORITHM);
        request.addHeader(X_Kss_DATE, signerParams.getFormattedSigningDateTime());
        this.addHost(request, ks3config);
        String contentSha256 = this.calculateContentHash(request, ks3config);
        request.addHeader(X_Kss_CONTENT_SHA256, contentSha256);
        String canonicalRequest = this.createCanonicalRequest(request, contentSha256, ks3config.isPathStyleAccess());
        String stringToSign = this.createStringToSign(canonicalRequest, signerParams);
        byte[] signingKey = this.deriveSigningKey(auth, signerParams);
        byte[] signature = this.computeSignature(stringToSign, signingKey, signerParams);
        String authorization = this.buildAuthorizationHeader(request, signature, auth, signerParams);
        request.addHeader(AUTHORIZATION, authorization);
        return authorization;
    }

    protected String calcSignature(Authorization auth, Request request, Ks3ClientConfig ks3config) throws SignatureException {
        KSSSignerRequestParams signerParams = new KSSSignerRequestParams(request, new Date(), request.getRegion(), "ks3", KSS4_SIGNING_ALGORITHM);
        this.addHost(request, ks3config);
        request.getHeaders().remove("User-Agent");
        String contentSha256 = UNSIGNED_PAYLOAD;
        String signingCredentials = auth.getAccessKeyId() + "/" + signerParams.getScope();
        request.getQueryParams().put(X_Kss_ALGORITHM, KSS4_SIGNING_ALGORITHM);
        request.getQueryParams().put(X_Kss_CREDENTIAL, signingCredentials);
        request.getQueryParams().put(X_Kss_DATE, signerParams.getFormattedSigningDateTime());
        Date date = new Date();
        request.getQueryParams().put(X_Kss_EXPIRES, String.valueOf((request.getExpires().getTime() - date.getTime()) / 1000L));
        request.addQueryParam(X_Kss_SIGNED_HEADER, this.getSignedHeadersString(request));
        String canonicalRequest = this.createCanonicalRequest(request, contentSha256, ks3config.isPathStyleAccess());
        String stringToSign = this.createStringToSign(canonicalRequest, signerParams);
        byte[] signingKey = this.deriveSigningKey(auth, signerParams);
        byte[] signature = this.computeSignature(stringToSign, signingKey, signerParams);
        String signer = BinaryUtils.toHex(signature);
        return signer;
    }

    private void addHost(Request request, Ks3ClientConfig ks3config) {
        String host = "";
        if (!(ks3config.isPathStyleAccess() || ks3config.isDomainMode() || StringUtils.isBlank(request.getBucket()))) {
            host = host + request.getBucket() + ".";
        }
        request.addHeader(HOST, host + request.getEndpoint());
    }

    protected String calculateContentHash(Request request, Ks3ClientConfig ks3ClientConfig) throws SignatureException {
        if (Ks3ClientConfig.SignerVersion.V4_UNSIGNED_PAYLOAD_SIGNER == ks3ClientConfig.getVersion()) {
            return UNSIGNED_PAYLOAD;
        }
        InputStream is = request.getContent();
        if (is != null && !is.markSupported()) {
            return UNSIGNED_PAYLOAD;
        }
        InputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        payloadStream.mark(0);
        String contentSha256 = BinaryUtils.toHex(this.hash(payloadStream));
        try {
            payloadStream.reset();
        }
        catch (Exception e) {
            throw new SignatureException("Unable to reset stream after calculating kss signature" + e);
        }
        return contentSha256;
    }

    protected byte[] hash(InputStream input) throws SignatureException {
        try {
            MessageDigest md = Ks3V4Signer.getMessageDigestInstance();
            SdkDigestInputStream digestInputStream = new SdkDigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new SignatureException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    private static MessageDigest getMessageDigestInstance() {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        messageDigest.reset();
        return messageDigest;
    }

    protected String getCanonicalizedQueryString(Request request) {
        return this.getCanonicalizedQueryString2(request.getQueryParams());
    }

    protected String getCanonicalizedQueryString2(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            paramNames.add(entry.getKey());
        }
        Collections.sort(paramNames);
        for (String paramName : paramNames) {
            sorted.put(paramName, parameters.get(paramName));
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(HttpUtils.urlEncode((String)entry.getKey(), false)).append("=").append(HttpUtils.urlEncode((String)entry.getValue(), false));
        }
        return result.toString();
    }

    protected InputStream getBinaryRequestPayloadStream(Request request) throws SignatureException {
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    protected InputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request request) throws SignatureException {
        try {
            InputStream is = request.getContent();
            if (is == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (!is.markSupported()) {
                throw new Exception("Unable to read request payload to sign request.");
            }
            return is;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Unable to read request payload to sign request: " + e.getMessage(), e);
        }
    }

    protected String createCanonicalRequest(Request request, String contentSha256, boolean pathStyleAccess) {
        String path1 = "";
        String path2 = "";
        if (pathStyleAccess && !StringUtils.isBlank(request.getBucket())) {
            path1 = path1 + "/" + request.getBucket();
        }
        if (!StringUtils.isBlank(request.getKey())) {
            path2 = "/" + request.getKey();
        }
        String path = SdkUtils.appendUri(path1, path2);
        StringBuilder canonicalRequestBuilder = new StringBuilder(request.getMethod().toString());
        canonicalRequestBuilder.append(LINE_SEPARATOR).append(this.getCanonicalizedResourcePath(path)).append(LINE_SEPARATOR).append(this.getCanonicalizedQueryString(request)).append(LINE_SEPARATOR).append(this.getCanonicalizedHeaderString(request)).append(LINE_SEPARATOR).append(this.getSignedHeadersString(request)).append(LINE_SEPARATOR).append(contentSha256);
        String canonicalRequest = canonicalRequestBuilder.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("kss4 Canonical Request: '\"" + canonicalRequest + "\""));
        }
        return canonicalRequest;
    }

    protected String createStringToSign(String canonicalRequest, KSSSignerRequestParams signerParams) throws SignatureException {
        StringBuilder stringToSignBuilder = new StringBuilder(signerParams.getSigningAlgorithm());
        stringToSignBuilder.append(LINE_SEPARATOR).append(signerParams.getFormattedSigningDateTime()).append(LINE_SEPARATOR).append(signerParams.getScope()).append(LINE_SEPARATOR).append(BinaryUtils.toHex(this.hash(canonicalRequest)));
        String stringToSign = stringToSignBuilder.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("kss4 String to Sign: '\"" + stringToSign + "\""));
        }
        return stringToSign;
    }

    public byte[] hash(String text) throws SignatureException {
        return Ks3V4Signer.doHash(text);
    }

    private static byte[] doHash(String text) throws SignatureException {
        try {
            MessageDigest md = Ks3V4Signer.getMessageDigestInstance();
            md.update(text.getBytes(StringUtils.UTF8));
            return md.digest();
        }
        catch (Exception e) {
            throw new SignatureException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedResourcePath(String resourcePath) {
        return this.getCanonicalizedResourcePath(resourcePath, true);
    }

    protected String getCanonicalizedResourcePath(String resourcePath, boolean urlEncode) {
        String value;
        if (resourcePath == null || resourcePath.isEmpty()) {
            return "/";
        }
        String string = value = urlEncode ? HttpUtils.urlEncode(resourcePath, true) : resourcePath;
        if (value.startsWith("/")) {
            return value;
        }
        return "/".concat(value);
    }

    private String getCanonicalizedHeaderString(Request request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(request.getHeaders().keySet());
        Map<String, String> headers = request.getHeaders();
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (this.shouldExcludeHeaderFromSigning(header)) continue;
            buffer.append((header.toLowerCase() + ":" + headers.get(header)).trim());
            buffer.append(LINE_SEPARATOR);
        }
        return buffer.toString();
    }

    protected boolean shouldExcludeHeaderFromSigning(String header) {
        return listOfHeadersToIgnoreInLowerCase.contains(header.toLowerCase());
    }

    protected String getSignedHeadersString(Request request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (this.shouldExcludeHeaderFromSigning(header)) continue;
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(StringUtils.lowerCase(header));
        }
        return buffer.toString();
    }

    private final byte[] deriveSigningKey(Authorization auth, KSSSignerRequestParams signerRequestParams) throws SignatureException {
        String cacheKey = this.computeSigningCacheKeyName(auth, signerRequestParams);
        long daysSinceEpochSigningDate = DateUtils.numberOfDaysSinceEpoch(signerRequestParams.getSigningDateTimeMilli());
        SignerKey signerKey = signerCache.get(cacheKey);
        if (signerKey != null && daysSinceEpochSigningDate == signerKey.getNumberOfDaysSinceEpoch()) {
            return signerKey.getSigningKey();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating a new signing key as the signing key not available in the cache for the date " + TimeUnit.DAYS.toMillis(daysSinceEpochSigningDate)));
        }
        byte[] signingKey = this.newSigningKey(auth, signerRequestParams.getFormattedSigningDate(), signerRequestParams.getRegionName(), signerRequestParams.getServiceName());
        signerCache.add(cacheKey, new SignerKey(daysSinceEpochSigningDate, signingKey));
        return signingKey;
    }

    private final String computeSigningCacheKeyName(Authorization auth, KSSSignerRequestParams signerRequestParams) {
        StringBuilder hashKeyBuilder = new StringBuilder(auth.getAccessKeySecret());
        return hashKeyBuilder.append("-").append(signerRequestParams.getRegionName()).append("-").append(signerRequestParams.getServiceName()).toString();
    }

    protected final byte[] computeSignature(String stringToSign, byte[] signingKey, KSSSignerRequestParams signerRequestParams) throws SignatureException {
        return this.sign(stringToSign.getBytes(Charset.forName("UTF-8")), signingKey, HMAC_SHA256_ALGORITHM);
    }

    private String buildAuthorizationHeader(Request request, byte[] signature, Authorization auth, KSSSignerRequestParams signerParams) {
        String signingCredentials = auth.getAccessKeyId() + "/" + signerParams.getScope();
        String credential = "Credential=" + signingCredentials;
        String signerHeaders = "SignedHeaders=" + this.getSignedHeadersString(request);
        String signatureHeader = "Signature=" + BinaryUtils.toHex(signature);
        StringBuilder authHeaderBuilder = new StringBuilder();
        authHeaderBuilder.append(KSS4_SIGNING_ALGORITHM).append(" ").append(credential).append(", ").append(signerHeaders).append(", ").append(signatureHeader);
        return authHeaderBuilder.toString();
    }

    protected byte[] newSigningKey(Authorization auth, String dateStamp, String regionName, String serviceName) throws SignatureException {
        byte[] kSecret = ("KSS4" + auth.getAccessKeySecret()).getBytes(Charset.forName("UTF-8"));
        byte[] kDate = this.sign(dateStamp, kSecret, HMAC_SHA256_ALGORITHM);
        byte[] kRegion = this.sign(regionName, kDate, HMAC_SHA256_ALGORITHM);
        byte[] kService = this.sign(serviceName, kRegion, HMAC_SHA256_ALGORITHM);
        return this.sign(KSS4_TERMINATOR, kService, HMAC_SHA256_ALGORITHM);
    }

    public byte[] sign(String stringData, byte[] key, String algorithm) throws SignatureException {
        try {
            byte[] data = stringData.getBytes(StringUtils.UTF8);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new SignatureException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, String algorithm) throws SignatureException {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new SignatureException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }
}

