/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.utils;

import com.ksyun.ks3.Crc64CheckedInputStream;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.utils.CRC64;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CRC64Utils {
    private static final Log log = LogFactory.getLog(CRC64Utils.class);
    private static final int SIXTEEN_K = 16384;

    private CRC64Utils() {
    }

    public static String getCrc64Ecma(File file) throws IOException {
        try (Crc64CheckedInputStream checkedInputstream = new Crc64CheckedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            byte[] buffer = new byte[16384];
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = checkedInputstream.read(buffer, 0, buffer.length);
            }
            String string = CRC64Utils.toUnsignedString(checkedInputstream.getChecksum().getValue());
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public static String getCrc64Ecma(File file, long startIndex, long endIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getCrc64Ecma(List<PartETag> partETags) {
        if (partETags == null || partETags.isEmpty()) {
            return null;
        }
        Collections.sort(partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag o1, PartETag o2) {
                return o1.getPartNumber() - o2.getPartNumber();
            }
        });
        Long firstCrc64Ecma = CRC64Utils.parseServerCrc64(partETags.get(0).getCrc64Ecma());
        if (firstCrc64Ecma == null) {
            return null;
        }
        CRC64 crc64 = new CRC64(firstCrc64Ecma);
        for (int i = 1; i < partETags.size(); ++i) {
            PartETag partETag = partETags.get(i);
            Long crc64Ecma = CRC64Utils.parseServerCrc64(partETag.getCrc64Ecma());
            if (crc64Ecma == null) {
                return null;
            }
            crc64 = CRC64.combine(crc64, new CRC64(crc64Ecma), partETag.getPartSize());
        }
        return CRC64Utils.toUnsignedString(crc64.getValue());
    }

    public static Long parseServerCrc64(String value) {
        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value)) {
            return null;
        }
        return new BigInteger(value).longValue();
    }

    public static String toUnsignedString(long value) {
        return CRC64Utils.toUnsignedString(value, 10);
    }

    public static String toUnsignedString(long value, int radix) {
        BigInteger unsignedValue = BigInteger.valueOf(value).and(new BigInteger("FFFFFFFFFFFFFFFF", 16));
        return unsignedValue.toString(radix);
    }
}

