/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.utils;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.BasicNameValuePair;
import com.ksyun.ks3.utils.URLEncodedUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;

public class SdkUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static boolean usePayloadForQueryParameters(Request request) {
        boolean requestIsPOST = HttpMethod.POST.equals((Object)request.getMethod());
        boolean requestHasNoPayload = request.getContent() == null;
        return requestIsPOST && requestHasNoPayload;
    }

    public static String encodeParameters(Request request) {
        Map<String, String> requestParams = request.getQueryParams();
        if (requestParams.isEmpty()) {
            return null;
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            String parameterName = entry.getKey();
            nameValuePairs.add(new BasicNameValuePair(parameterName, entry.getValue()));
        }
        return URLEncodedUtils.format(nameValuePairs, DEFAULT_ENCODING);
    }

    public static String appendUri(String baseUri, String path) {
        return SdkUtils.appendUri(baseUri, path, false);
    }

    public static String appendUri(String baseUri, String path, boolean escapeDoubleSlash) {
        String resultUri = baseUri;
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                if (resultUri.endsWith("/")) {
                    resultUri = resultUri.substring(0, resultUri.length() - 1);
                }
            } else if (!resultUri.endsWith("/")) {
                resultUri = resultUri + "/";
            }
            resultUri = escapeDoubleSlash ? resultUri + path.replace("//", "/%2F") : resultUri + path;
        }
        return resultUri;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

