package com.ksyun.ks3.dto;

import com.ksyun.ks3.utils.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author lijunwei[lijunwei@kingsoft.com]  
 *
 * @date 2014年11月10日 下午1:47:26
 *
 * @description
 * <p>public CreateBucketConfiguration({@link REGION} region)</p>
 * <P>bucket存储地点配置，用于{@link com.ksyun.ks3.service.request.CreateBucketRequest}</P>
 **/
public class CreateBucketConfiguration {
	/**
	 * bucket存储地点
	 * @author LIJUNWEI
	 *
	 */
	public static enum REGION {
		HANGZHOU,AMERICA,HONGKONG,BEIJING,SHANGHAI,GUANGZHOU,SINGAPORE,RUSSIA,TAIWAN,QINGDAO,JR_BEIJING,JR_SHANGHAI,GOV_BEIJING,INDIA, UNKNOWN;

		private static final Log log = LogFactory.getLog(REGION.class);

		public static REGION load(String s){
			for(REGION region :REGION.values()){
				if(region.toString().equals(s))
					return region;
			}
			log.warn("unknown region: " + s + ", use UNKNOWN instead");
			return UNKNOWN;
		}
	}
	public CreateBucketConfiguration(REGION region){
		this.location = region;
	}
	private REGION location;

	public REGION getLocation() {
		return location;
	}

	public void setLocation(REGION location) {
		this.location = location;
	}

	public String toString() {
		return StringUtils.object2string(this);
	}
}
