package com.ksyun.ks3.http.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;

import com.ksyun.ks3.signer.internal.FIFOCache;

/**
 * Using local cache when UnknownHostException
 *
 */
public class Ks3DnsResolver implements DnsResolver{
	
	private final Log log = LogFactory.getLog(this.getClass());

	public static final Ks3DnsResolver INSTANCE = new Ks3DnsResolver();
	
	private static final int CACHE_MAX_SIZE = 300;
	
	private static final FIFOCache<InetAddress[]> cache = new FIFOCache<InetAddress[]>(CACHE_MAX_SIZE);
	
	@Override
	public InetAddress[] resolve(String host) throws UnknownHostException {
		InetAddress[] addressArr = null;
		try {
			addressArr = SystemDefaultDnsResolver.INSTANCE.resolve(host);
			if(addressArr != null) {
				cache.add(host, addressArr);
			}
			return addressArr;
		}catch(UnknownHostException e) {
			
			log.warn("Resolve host fail, will use cache. Cause:", e);
			addressArr = cache.get(host);
			if(addressArr != null) {
				return addressArr;
			}
			log.debug("Also not found in cache.");
			throw e;
		}
	}

}
