
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.dto.*;
import com.ksyun.ks3.service.request.*;

import java.io.File;


/**
 * An internal SPI used to implement different cryptographic modules
 * for use with the S3 encryption client.
 */
public abstract class S3CryptoModule<T extends MultipartUploadContext> {
    public abstract PutObjectResult putObjectSecurely(PutObjectRequest req);

    public abstract GetObjectResult getObjectSecurely(GetObjectRequest req);

    public abstract ObjectMetadata getObjectSecurely(GetObjectRequest req,
            File dest);

    public abstract CompleteMultipartUploadResult completeMultipartUploadSecurely(
            CompleteMultipartUploadRequest req);

    public abstract InitiateMultipartUploadResult initiateMultipartUploadSecurely(
            InitiateMultipartUploadRequest req);

    public abstract PartETag uploadPartSecurely(UploadPartRequest req);

    public abstract CopyResult copyPartSecurely(CopyPartRequest req);

    public abstract void abortMultipartUploadSecurely(AbortMultipartUploadRequest req);
}
