package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

/**
 * 删除空间策略请求
 * @author yanghui4
 */
public class DeleteBucketPolicyRequest extends Ks3WebServiceRequest {
    private String bucketName;

    public DeleteBucketPolicyRequest(){

    }

    public DeleteBucketPolicyRequest(String bucketName) {
        this.bucketName = bucketName;
    }


    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucketName)) {
            throw notNull("bucketName");
        }
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.DELETE);
        request.setBucket(bucketName);
        request.addQueryParam("policy", "");
    }
}
