package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

/**
 * 获取空间策略请求
 * @author yanghui4
 */
public class GetBucketPolicyRequest extends Ks3WebServiceRequest {
    private String bucketName;

    public GetBucketPolicyRequest(){

    }

    public GetBucketPolicyRequest(String bucketName) {
        this.bucketName = bucketName;
    }


    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucketName)) {
            throw notNull("bucketName");
        }
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(bucketName);
        request.addQueryParam("policy", "");
    }
}
