package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

/**
 * 设置空间策略请求
 * @author yanghui4
 */
public class PutBucketPolicyRequest extends Ks3WebServiceRequest {
    private String bucketName;
    private String policyText;

    public PutBucketPolicyRequest(){

    }

    public PutBucketPolicyRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public PutBucketPolicyRequest(String bucketName, String policyText) {
        this.bucketName = bucketName;
        this.policyText = policyText;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPolicyText() {
        return policyText;
    }

    public void setPolicyText(String policyText) {
        this.policyText = policyText;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucketName)) {
            throw notNull("bucketName");
        }
        if (StringUtils.isBlank(this.policyText)) {
            throw notNull("bucketPolicyText");
        }
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(bucketName);
        request.setContent(new ByteArrayInputStream(policyText.getBytes(StandardCharsets.UTF_8)));
        request.addQueryParam("policy", "");
    }
}
