package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.BucketLifecycleConfiguration;
import com.ksyun.ks3.dto.BucketLifecycleConfiguration.AbortMultipartUpload;
import com.ksyun.ks3.dto.BucketLifecycleConfiguration.Rule;
import com.ksyun.ks3.dto.BucketLifecycleConfiguration.Status;
import com.ksyun.ks3.dto.BucketLifecycleConfiguration.Transition;
import com.ksyun.ks3.dto.ObjectTag;
import com.ksyun.ks3.utils.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.util.ArrayList;
import java.util.List;


public class GetBucketLifecycleResponse extends
		Ks3WebServiceXmlResponse<BucketLifecycleConfiguration> {

	private Rule rule = null;
	private final List<Rule> rules = new ArrayList<>();
	private List<Transition> storageTransList;
	private Transition transition = null;
	private List<ObjectTag> tagSet;
	private ObjectTag tagging;
	private AbortMultipartUpload abortMultipartUpload = null;

	@Override
	public void startDocument() throws SAXException {
		result = new BucketLifecycleConfiguration();
	}

	@Override
	public void startEle(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		String tag = getTag();
		if ("Rule".equals(tag)) {
			rule = new Rule();
			storageTransList = new ArrayList<>();
			tagSet = new ArrayList<>();
		}else if ("Transition".equals(tag)){
			transition = new Transition();
		} else if ("Tag".equals(tag)) {
			tagging = new ObjectTag();
		} else if ("AbortIncompleteMultipartUpload".equals(tag)) {
			abortMultipartUpload = new AbortMultipartUpload();
		}
	}

	@Override
	public void endEle(String uri, String localName, String qName)
			throws SAXException {
		String tag = getTag();
		if ("Rule".equals(tag)) {
			if(storageTransList != null && !storageTransList.isEmpty()){
				rule.setStorageTransitions(storageTransList);
			}
			if (tagSet != null && !tagSet.isEmpty()) {
				rule.setTagSet(tagSet);
			}
			rules.add(rule);
		} else if ("LifecycleConfiguration".equals(tag)) {
			result.setRules(rules);
		}else if ("Transition".equals(tag)){
			storageTransList.add(transition);
		} else if ("Tag".equals(tag)) {
			if (tagSet != null) {
				tagSet.add(tagging);
			}
		} else if ("AbortIncompleteMultipartUpload".equals(tag)) {
			rule.setAbortMultipartUpload(abortMultipartUpload);
		}
	}

	@Override
	public void string(String s) {
		String tag = getTag();
		if ("ID".equals(tag)) {
			rule.setId(s);
		} else if ("Prefix".equals(tag)) {
			rule.setPrefix(s);
		} else if ("Status".equals(tag)) {
			rule.setStatus(Status.str2Status(s));
		}else if("Expiration".equals(getTag(1))){
			if ("Date".equals(tag)) {
				rule.setExpirationDate(DateUtils.convertStr2Date(s));
			} else if ("Days".equals(tag)) {
				rule.setExpirationInDays(Integer.valueOf(s));
			}
		}
		else if("Transition".equals(getTag(1))){
			if ("Date".equals(tag)) {
				transition.setTransDate(DateUtils.convertStr2Date(s));
			} else if ("Days".equals(tag)) {
				transition.setTransDays(Integer.valueOf(s));
			}
			else if ("StorageClass".equals(tag)) {
				transition.setStorageClass(s);
			}
		} else if ("Tag".equals(getTag(1))) {
			if ("Key".equals(tag)) {
				tagging.setKey(s);
			} else if ("Value".equals(tag)) {
				tagging.setValue(s);
			}
		} else if ("AbortIncompleteMultipartUpload".equals(getTag(1))) {
			if ("Date".equals(tag)) {
				abortMultipartUpload.setCreatedBeforeDate(DateUtils.convertStr2Date(s));
			} else if ("DaysAfterInitiation".equals(tag)) {
				abortMultipartUpload.setExpirationDays(Integer.parseInt(s));
			}
		}
		
	}

	@Override
	public void preHandle() {

	}

	public int[] expectedStatus() {
		return new int[] { 200 };
	}
}
