package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.BucketRetentionConfiguration;
import com.ksyun.ks3.dto.BucketRetentionConfiguration.Status;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;


public class GetBucketRetentionResponse extends
        Ks3WebServiceXmlResponse<BucketRetentionConfiguration> {

    private BucketRetentionConfiguration.Rule rule;

    @Override
    public void startDocument() throws SAXException {
        result = new BucketRetentionConfiguration();
    }

    @Override
    public void startEle(String uri, String localName, String qName,
                         Attributes attributes) throws SAXException {
        String tag = getTag();
        if ("Rule".equals(tag)) {
            rule = new BucketRetentionConfiguration.Rule();
        }
    }

    @Override
    public void endEle(String uri, String localName, String qName)
            throws SAXException {
        String tag = getTag();
        if ("Rule".equals(tag)) {
            result.setRule(rule);
        }
    }

    @Override
    public void string(String s) {
        String tag = getTag();
        if ("Status".equals(tag)) {
            rule.setStatus(Status.str2Status(s));
        } else if ("Days".equals(tag)) {
            rule.setDays(Integer.parseInt(s));
        }
    }

    @Override
    public void preHandle() {

    }

    public int[] expectedStatus() {
        return new int[]{200};
    }
}
