package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.Owner;
import com.ksyun.ks3.dto.RetentionObject;
import com.ksyun.ks3.dto.RetentionObjectListing;
import com.ksyun.ks3.utils.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yanghui4
 * @date 2023-09-21
 */
public class ListRetentionObjectsResponse extends
        Ks3WebServiceXmlResponse<RetentionObjectListing> {

    private List<RetentionObject> objs = null;
    private RetentionObject obj = null;
    private Owner owner = null;

    @Override
    public void startDocument() throws SAXException {
        result = new RetentionObjectListing();
        objs = new ArrayList<>();
    }

    @Override
    public void startEle(String uri, String localName, String qName,
                         Attributes attributes) throws SAXException {
        String tag = getTag();
        if ("Contents".equals(tag)) {
            obj = new RetentionObject();
        } else if ("Owner".equals(tag)) {
            owner = new Owner();
        }
    }

    @Override
    public void endEle(String uri, String localName, String qName)
            throws SAXException {
        String tag = getTag();
        if ("Owner".equals(tag)) {
            obj.setOwner(owner);
        } else if ("Contents".equals(tag)) {
            obj.setBucketName(result.getBucketName());
            objs.add(obj);
        } else if ("ListRetentionResult".equals(tag)) {
            result.setRetentionObjects(objs);
        }
    }

    @Override
    public void string(String s) {
        String tag = getTag();
        if ("Name".equals(tag)) {
            result.setBucketName(s);
        } else if ("Prefix".equals(tag)) {
            result.setPrefix(s);
        } else if ("Marker".equals(tag)) {
            result.setMarker(s);
        } else if ("MaxKeys".equals(tag)) {
            result.setMaxKeys(Integer.parseInt(s));
        } else if ("Delimiter".equals(tag)) {
            result.setDelimiter(s);
        } else if ("IsTruncated".equals(tag)) {
            result.setTruncated("true".equals(s));
        } else if ("NextMarker".equals(tag)) {
            result.setNextMarker(s);
        } else if ("Encoding-Type".equals(tag)) {
            result.setEncodingType(s);
        } else if ("Key".equals(tag)) {
            obj.setKey(s);
        } else if ("LastModified".equals(tag)) {
            obj.setLastModified(DateUtils.convertStr2Date(s));
        } else if ("ETag".equals(tag)) {
            obj.setETag(s);
        } else if ("Size".equals(tag)) {
            obj.setSize(Long.parseLong(s));
        } else if ("Type".equals(tag)) {
            obj.setType(s);
        } else if ("StorageClass".equals(tag)) {
            obj.setStorageClass(s);
        } else if ("RetentionId".equals(tag)) {
            obj.setRetentionId(s);
        } else if ("RecycleTime".equals(tag)) {
            obj.setRecycleTime(DateUtils.convertStr2Date(s));
        } else if ("EstimatedClearTime".equals(tag)) {
            obj.setEstimatedClearTime(DateUtils.convertStr2Date(s));
        } else if ("ID".equals(tag)) {
            owner.setId(s);
        } else if ("DisplayName".equals(tag)) {
            owner.setDisplayName(s);
        }
    }

    @Override
    public void preHandle() {

    }

    public int[] expectedStatus() {
        return new int[]{200};
    }
}
