
package com.ksyun.ks3.signer.internal;


import com.ksyun.ks3.annotation.SdkProtectedApi;

import java.util.ArrayList;
import java.util.List;

@SdkProtectedApi
public final class SdkThreadLocalsRegistry {

    private static final List<ThreadLocal<?>> threadLocals = new ArrayList<ThreadLocal<?>>();

    private SdkThreadLocalsRegistry() {
        // prevent instantiation
    }

    /**
     * Registers {@link ThreadLocal} objects in use by the AWS SDK so that their values can 
     * be removed via the {@link #remove()} method.
     *
     * <p>To avoid memory leaks and reduce contention this method should only be called when 
     * setting static final locations (for example finals in enums or static final fields).
     *
     * @param threadLocal ThreadLocal to register
     * @return the input ThreadLocal
     */
    public static synchronized <T> ThreadLocal<T> register(ThreadLocal<T> threadLocal) {
        threadLocals.add(threadLocal);
        return threadLocal;
    }

    public synchronized static void remove() {
        for (ThreadLocal<?> t: threadLocals) {
            t.remove();
        }
    }

}