package com.ksyun.ks3.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.Closeable;
import java.io.IOException;

/**
 * @author yanghui4
 */
public class CommonUtils {
    private static final Log log = LogFactory.getLog(CommonUtils.class);

    public static void closeQuietly(Closeable closeable) {
        closeQuietly(closeable, "");
    }

    public static void closeQuietly(Closeable closeable, String message) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        } catch (IOException e) {
            log.error(message, e);
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}
