package com.ksyun.ks3.utils;

import java.io.*;

public class FileInputStream2 extends InputStream {
    private FileInputStream fis = null;
    private FileInputStream fis2 = null;
    private File file = new File("D:\\.m2.rar");
    private byte[] buff = null;
    private long bytesReadPastMarkPoint = 0;
    private long markPoint = 0;
    public FileInputStream2(InputStream in) throws FileNotFoundException {
        this.fis = (FileInputStream) in;
    }


    @Override
    public void reset() throws IOException {
        fis.close();
        fis = new FileInputStream(file);
        file = null;
        long skipped = 0;
        long toSkip = markPoint;
        while (toSkip > 0) {
            skipped = this.fis.skip(toSkip);
            toSkip -= skipped;
        }
        this.bytesReadPastMarkPoint = 0;
    }
    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markPoint += bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0;
    }

    @Override
    public int available() throws IOException {
        return fis.available();
    }

    @Override
    public void close() throws IOException {
        fis.close();
    }

    @Override
    public int read() throws IOException {
        int byteRead = fis.read();
        if (byteRead != -1) {
            bytesReadPastMarkPoint++;
            return byteRead;
        } else {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = fis.skip(n);
        bytesReadPastMarkPoint += skipped;
        return skipped;
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int count = fis.read(arg0, arg1, arg2);
        bytesReadPastMarkPoint += count;
        return count;
    }
}
