package com.ksyun.ks3.utils;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/**
 * @author chencheng
 *
 * @date 2019年10月8日 下午4:06:43
 *
 * @description
 **/
public class SdkUtils {

    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public SdkUtils(){

    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+"))
                .append("|")
                .append(Pattern.quote("*"))
                .append("|")
                .append(Pattern.quote("%7E"))
                .append("|")
                .append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }

    public static boolean usePayloadForQueryParameters(Request request) {
        boolean requestIsPOST = HttpMethod.POST.equals(request.getMethod());
        boolean requestHasNoPayload = (request.getContent() == null);

        return requestIsPOST && requestHasNoPayload;
    }

    /**
     * Creates an encoded query string from all the parameters in the specified
     * request.
     *
     * @param request
     *            The request containing the parameters to encode.
     *
     * @return Null if no parameters were present, otherwise the encoded query
     *         string for the parameters present in the specified request.
     */
    public static String encodeParameters(Request request) {

        final Map<String, String> requestParams = request.getQueryParams();
        if (requestParams.isEmpty()) return null;

        final List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();

        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            String parameterName = entry.getKey();
            nameValuePairs.add(new BasicNameValuePair(parameterName, entry.getValue()));
        }

        return URLEncodedUtils.format(nameValuePairs, DEFAULT_ENCODING);
    }


    public static String appendUri(String baseUri, String path) {
        return appendUri(baseUri, path, false);
    }

    public static String appendUri(final String baseUri, String path, final boolean escapeDoubleSlash) {
        String resultUri = baseUri;
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                // trim the trailing slash in baseUri, since the path already starts with a slash
                if (resultUri.endsWith("/")) {
                    resultUri = resultUri.substring(0, resultUri.length() - 1);
                }
            } else if (!resultUri.endsWith("/")) {
                resultUri += "/";
            }
            if (escapeDoubleSlash) {
                resultUri += path.replace("//", "/%2F");
            } else {
                resultUri += path;
            }
        }

        return resultUri;
    }


}
