package com.ksyun.ks3.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLEncodeUtils {
    private static final Log log = LogFactory.getLog(URLEncodeUtils.class);

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("Error occurred when encode: " + str, e);
        }
        return str;
    }
}
