/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http.internal;

import com.ksyun.ks3.http.internal.Ks3SSLSocket;
import com.ksyun.ks3.http.internal.Ks3Socket;
import com.ksyun.ks3.http.internal.TLSProtocol;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;

public class TLSSocketFactory
extends SSLSocketFactory {
    private static final Log log = LogFactory.getLog(TLSSocketFactory.class);

    public TLSSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
    }

    protected final void prepareSocket(SSLSocket socket) {
        Object[] supported = socket.getSupportedProtocols();
        Object[] enabled = socket.getEnabledProtocols();
        if (log.isDebugEnabled()) {
            log.debug((Object)("socket.getSupportedProtocols(): " + Arrays.toString(supported) + ", socket.getEnabledProtocols(): " + Arrays.toString(enabled)));
        }
        ArrayList<Object> target = new ArrayList<Object>();
        if (supported != null) {
            TLSProtocol[] values = TLSProtocol.values();
            for (int i = 0; i < values.length; ++i) {
                String pname = values[i].getProtocolName();
                if (!this.existsIn(pname, (String[])supported)) continue;
                target.add(pname);
            }
        }
        if (enabled != null) {
            for (Object pname : enabled) {
                if (target.contains(pname)) continue;
                target.add(pname);
            }
        }
        if (target.size() > 0) {
            Object[] enabling = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols((String[])enabling);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TLS protocol enabled for SSL handshake: " + Arrays.toString(enabling)));
            }
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("connecting to " + remoteAddress.getAddress() + ":" + remoteAddress.getPort()));
        }
        this.verifyMasterSecret(super.connectSocket(socket, remoteAddress, localAddress, params));
        if (socket instanceof SSLSocket) {
            return new Ks3SSLSocket((SSLSocket)socket);
        }
        return new Ks3Socket(socket);
    }

    private void verifyMasterSecret(Socket sock) {
        String className;
        SSLSocket ssl;
        SSLSession session;
        if (sock instanceof SSLSocket && (session = (ssl = (SSLSocket)sock).getSession()) != null && "sun.security.ssl.SSLSessionImpl".equals(className = session.getClass().getName())) {
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getDeclaredMethod("getMasterSecret", new Class[0]);
                method.setAccessible(true);
                Object masterSecret = method.invoke((Object)session, new Object[0]);
                if (masterSecret == null) {
                    throw this.log(new SecurityException("Invalid SSL master secret"));
                }
            }
            catch (ClassNotFoundException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (NoSuchMethodException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (IllegalAccessException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (InvocationTargetException e) {
                this.failedToVerifyMasterSecret(e.getCause());
            }
        }
    }

    private void failedToVerifyMasterSecret(Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Failed to verify the SSL master secret", t);
        }
    }

    private <T extends Throwable> T log(T t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"", t);
        }
        return t;
    }
}

