/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.common;

import com.ksyun.ks3.AutoAbortInputStream;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.service.Ks3Client;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.utils.CommonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiThreadDownloader {
    private static final Log log = LogFactory.getLog(MultiThreadDownloader.class);
    private PipedOutputStream pipedOut;
    private BufferedInputStream bufferedInputStream;
    private final Ks3Client client;
    private final GetObjectRequest request;
    private final GetObjectResult object;
    private static final int PIPE_SIZE = 0x100000;

    public MultiThreadDownloader(Ks3Client client, GetObjectRequest request, GetObjectResult object) {
        this.client = client;
        this.request = request;
        this.object = object;
        this.init();
    }

    private void validateRange() {
        long[] range = this.request.getRange();
        if (range == null) {
            return;
        }
        if (range.length != 2) {
            log.warn((Object)"Invalid range value: {}, ignore it and request for entire object");
            return;
        }
        if (range[0] < 0L) {
            throw new IllegalArgumentException("The start of range must not be negative");
        }
        if (range[1] < 0L) {
            throw new IllegalArgumentException("The end of range must not be negative");
        }
    }

    private void init() throws Ks3ClientException {
        log.debug((Object)"use multiThread...");
        this.validateRange();
        try {
            this.pipedOut = new PipedOutputStream();
            PipedInputStream pipedIn = new PipedInputStream(this.pipedOut, 0x100000);
            this.bufferedInputStream = new BufferedInputStream(pipedIn);
        }
        catch (Exception e) {
            throw new Ks3ClientException(e);
        }
        new Thread(new MultipartDownloadWorker()).start();
    }

    public InputStream getInputStream() {
        return this.bufferedInputStream;
    }

    class FilePartDownloadWorker
    implements Callable<byte[]> {
        private final long start;
        private final long end;
        public static final int EOF = -1;

        public FilePartDownloadWorker(long start, long end) {
            this.start = start;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] call() throws Exception {
            Exception ex = null;
            byte[] bytes = new byte[(int)(this.end - this.start + 1L)];
            int maxTryTimes = MultiThreadDownloader.this.client.getKs3config().getMultiThreadDownloadConf().getMaxTryTimes();
            for (int i = 0; i < maxTryTimes; ++i) {
                if (i > 0) {
                    CommonUtils.sleep(100L * (long)i);
                }
                AutoAbortInputStream inputStream = null;
                try {
                    GetObjectRequest req = new GetObjectRequest(MultiThreadDownloader.this.request.getBucket(), MultiThreadDownloader.this.request.getKey());
                    req.setRange(this.start, this.end);
                    req.setMultiThread(false);
                    GetObjectResult result = MultiThreadDownloader.this.client.getObject(req);
                    inputStream = result.getObject().getObjectContent();
                    this.read(inputStream, bytes);
                    ex = null;
                    CommonUtils.closeQuietly(inputStream);
                    break;
                }
                catch (Exception e) {
                    String message = e.getMessage() + ", part info: start = " + this.start + ", end = " + this.end;
                    ex = new Exception(message, e);
                    continue;
                }
                finally {
                    CommonUtils.closeQuietly(inputStream);
                }
            }
            if (ex != null) {
                throw ex;
            }
            return bytes;
        }

        public int read(InputStream input, byte[] buffer) throws IOException {
            return this.read(input, buffer, 0, buffer.length);
        }

        public int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
            int location;
            int remaining;
            int count;
            if (length < 0) {
                throw new IllegalArgumentException("Length must not be negative: " + length);
            }
            for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
            }
            return length - remaining;
        }
    }

    class MultipartDownloadWorker
    implements Runnable {
        MultipartDownloadWorker() {
        }

        @Override
        public void run() {
            Ks3ClientConfig.MultiThreadDownloadConf conf = MultiThreadDownloader.this.client.getKs3config().getMultiThreadDownloadConf();
            int threadNum = conf.getThreadNum();
            long blockSize = conf.getBlockSize();
            ExecutorService downThread = Executors.newFixedThreadPool(threadNum);
            boolean isRange = MultiThreadDownloader.this.request.getRange() != null && MultiThreadDownloader.this.request.getRange().length == 2;
            try {
                long length = MultiThreadDownloader.this.object.getObject().getObjectMetadata().getContentLength();
                if (isRange) {
                    length = MultiThreadDownloader.this.object.getObject().getObjectMetadata().getInstanceLength();
                }
                long totalParts = (long)Math.ceil((double)length / (double)blockSize);
                int partIndex = 0;
                LinkedBlockingQueue<Future<byte[]>> queue = new LinkedBlockingQueue<Future<byte[]>>();
                while ((long)partIndex < totalParts) {
                    int addNum = partIndex == 0 ? threadNum + 1 : 1;
                    int i = 0;
                    while (i < addNum && (long)partIndex < totalParts) {
                        long start = (long)partIndex * blockSize;
                        long end = ((long)(partIndex + 1) == totalParts ? length : (long)(partIndex + 1) * blockSize) - 1L;
                        if (isRange) {
                            start = MultiThreadDownloader.this.request.getRange()[0] + (long)partIndex * blockSize;
                            end = (long)(partIndex + 1) == totalParts ? MultiThreadDownloader.this.request.getRange()[1] : MultiThreadDownloader.this.request.getRange()[0] + (long)(partIndex + 1) * blockSize - 1L;
                        }
                        log.debug((Object)("download block:" + partIndex + ", start=" + start + ", end=" + end));
                        FilePartDownloadWorker worker = new FilePartDownloadWorker(start, end);
                        queue.add(downThread.submit(worker));
                        ++i;
                        ++partIndex;
                    }
                    if (queue.isEmpty()) continue;
                    byte[] b = (byte[])((Future)queue.poll()).get();
                    MultiThreadDownloader.this.pipedOut.write(b);
                }
                while (!queue.isEmpty()) {
                    byte[] bytes = (byte[])((Future)queue.poll()).get();
                    MultiThreadDownloader.this.pipedOut.write(bytes);
                }
            }
            catch (Exception e) {
                throw new Ks3ClientException(e);
            }
            finally {
                CommonUtils.closeQuietly(MultiThreadDownloader.this.pipedOut);
                downThread.shutdownNow();
            }
        }
    }
}

