/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.common.StorageClass;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CopyObjectRequest
extends Ks3WebServiceRequest {
    private String destinationBucket;
    private String destinationKey;
    private String sourceBucket;
    private String sourceKey;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String storageClass;
    private ObjectMetadata newObjectMetadata;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private SSECustomerKey sourceSSECustomerKey;
    private SSECustomerKey destinationSSECustomerKey;

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey) {
        this.destinationBucket = destinationBucket;
        this.destinationKey = destinationObject;
        this.setSourceBucket(sourceBucket);
        this.setSourceKey(sourceKey);
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, CannedAccessControlList cannedAcl) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setCannedAcl(cannedAcl);
    }

    public CopyObjectRequest(String destinationBucket, String destinationObject, String sourceBucket, String sourceKey, AccessControlList accessControlList) {
        this(destinationBucket, destinationObject, sourceBucket, sourceKey);
        this.setAccessControlList(accessControlList);
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public void setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
    }

    public String getDestinationKey() {
        return this.destinationKey;
    }

    public void setDestinationKey(String destinationKey) {
        this.destinationKey = destinationKey;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public ObjectMetadata getNewObjectMetadata() {
        return this.newObjectMetadata;
    }

    public void setNewObjectMetadata(ObjectMetadata newObjectMetadata) {
        this.newObjectMetadata = newObjectMetadata;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> matchingETagConstraints) {
        this.matchingETagConstraints = matchingETagConstraints;
    }

    public List<String> getNonmatchingEtagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingEtagConstraints(List<String> nonmatchingEtagConstraints) {
        this.nonmatchingEtagConstraints = nonmatchingEtagConstraints;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date unmodifiedSinceConstraint) {
        this.unmodifiedSinceConstraint = unmodifiedSinceConstraint;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date modifiedSinceConstraint) {
        this.modifiedSinceConstraint = modifiedSinceConstraint;
    }

    public SSECustomerKey getSourceSSECustomerKey() {
        return this.sourceSSECustomerKey;
    }

    public void setSourceSSECustomerKey(SSECustomerKey sourceSSECustomerKey) {
        this.sourceSSECustomerKey = sourceSSECustomerKey;
    }

    public SSECustomerKey getDestinationSSECustomerKey() {
        return this.destinationSSECustomerKey;
    }

    public void setDestinationSSECustomerKey(SSECustomerKey destinationSSECustomerKey) {
        this.destinationSSECustomerKey = destinationSSECustomerKey;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.destinationBucket);
        request.setKey(this.destinationKey);
        request.addHeader(HttpHeaders.XKssCopySource, ("/" + this.getSourceBucket() + "/" + HttpUtils.urlEncode(this.getSourceKey(), true)).replace("//", "/%2F"));
        if (this.sourceBucket == this.destinationBucket && this.sourceKey == this.destinationKey && this.newObjectMetadata != null && "REPLACE".equals(this.newObjectMetadata.getMeta(HttpHeaders.XKssMetadataDirective.toString()))) {
            request.addHeader(HttpHeaders.ContentType.toString(), null);
        }
        if (this.getCannedAcl() != null) {
            request.addHeader(HttpHeaders.CannedAcl, this.getCannedAcl().toString());
        }
        request.getHeaders().putAll(HttpUtils.convertMeta2Headers(this.newObjectMetadata));
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.destinationSSECustomerKey));
        request.getHeaders().putAll(HttpUtils.convertCopySourceSSECustomerKey2Headers(this.sourceSSECustomerKey));
        if (this.accessControlList != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.accessControlList));
        }
        if (this.storageClass != null) {
            request.addHeader(HttpHeaders.StorageClass, this.storageClass);
        }
        if (this.matchingETagConstraints != null && this.matchingETagConstraints.size() > 0) {
            request.addHeader(HttpHeaders.CopySourceIfMatch, StringUtils.join(this.matchingETagConstraints, ","));
        }
        if (this.nonmatchingEtagConstraints != null && this.nonmatchingEtagConstraints.size() > 0) {
            request.addHeader(HttpHeaders.CopySourceIfNoneMatch, StringUtils.join(this.nonmatchingEtagConstraints, ","));
        }
        if (this.unmodifiedSinceConstraint != null) {
            request.addHeader(HttpHeaders.CopySourceIfUnmodifiedSince, DateUtils.convertDate2Str(this.unmodifiedSinceConstraint, DateUtils.DATETIME_PROTOCOL.RFC1123));
        }
        if (this.modifiedSinceConstraint != null) {
            request.addHeader(HttpHeaders.CopySourceIfModifiedSince, DateUtils.convertDate2Str(this.modifiedSinceConstraint, DateUtils.DATETIME_PROTOCOL.RFC1123));
        }
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.sourceBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceBucket");
        }
        if (StringUtils.isBlank(this.sourceKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceKey");
        }
        if (StringUtils.isBlank(this.destinationBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationBucket");
        }
        if (StringUtils.isBlank(this.destinationKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationKey");
        }
        if (Objects.equals(this.storageClass, StorageClass.UNKNOWN.toString())) {
            throw new ClientIllegalArgumentException("invalid storage class: " + this.storageClass);
        }
    }
}

