/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.SSECustomerKey;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.DateUtils;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CopyPartRequest
extends Ks3WebServiceRequest {
    private String destinationBucket;
    private String destinationKey;
    private String sourceBucket;
    private String sourceObject;
    private long beginRange = -1L;
    private long endRange = -1L;
    private int partNumber;
    private String uploadId;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private SSECustomerKey sourceSSECustomerKey;
    private SSECustomerKey destinationSSECustomerKey;

    public CopyPartRequest(String sourceBucket, String sourceObject, String destinationBucket, String destinationObject, int partNumber, String uploadId) {
        this.destinationBucket = destinationBucket;
        this.destinationKey = destinationObject;
        this.sourceBucket = sourceBucket;
        this.sourceObject = sourceObject;
        this.partNumber = partNumber;
        this.uploadId = uploadId;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.sourceBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceBucket");
        }
        if (StringUtils.isBlank(this.sourceObject)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("sourceObject");
        }
        if (StringUtils.isBlank(this.destinationBucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationBucket");
        }
        if (StringUtils.isBlank(this.destinationKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("destinationObject");
        }
        if (this.partNumber < 1 || this.partNumber > 10000) {
            throw ClientIllegalArgumentExceptionGenerator.between("partNumber", String.valueOf(this.partNumber), String.valueOf(1), String.valueOf(10000));
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("uploadId");
        }
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public String getSourceObject() {
        return this.sourceObject;
    }

    public void setSourceObject(String sourceObject) {
        this.sourceObject = sourceObject;
    }

    public long getBeginRange() {
        return this.beginRange;
    }

    public void setBeginRange(long beginRange) {
        this.beginRange = beginRange;
    }

    public long getEndRange() {
        return this.endRange;
    }

    public void setEndRange(long endRange) {
        this.endRange = endRange;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> matchingETagConstraints) {
        this.matchingETagConstraints = matchingETagConstraints;
    }

    public List<String> getNonmatchingEtagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingEtagConstraints(List<String> nonmatchingEtagConstraints) {
        this.nonmatchingEtagConstraints = nonmatchingEtagConstraints;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date unmodifiedSinceConstraint) {
        this.unmodifiedSinceConstraint = unmodifiedSinceConstraint;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date modifiedSinceConstraint) {
        this.modifiedSinceConstraint = modifiedSinceConstraint;
    }

    public SSECustomerKey getSourceSSECustomerKey() {
        return this.sourceSSECustomerKey;
    }

    public void setSourceSSECustomerKey(SSECustomerKey sourceSSECustomerKey) {
        this.sourceSSECustomerKey = sourceSSECustomerKey;
    }

    public SSECustomerKey getDestinationSSECustomerKey() {
        return this.destinationSSECustomerKey;
    }

    public void setDestinationSSECustomerKey(SSECustomerKey destinationSSECustomerKey) {
        this.destinationSSECustomerKey = destinationSSECustomerKey;
    }

    @Override
    public void buildRequest(Request request) {
        request.setBucket(this.destinationBucket);
        request.setKey(this.destinationKey);
        request.setMethod(HttpMethod.PUT);
        request.getQueryParams().put("partNumber", String.valueOf(this.partNumber));
        request.getQueryParams().put("uploadId", String.valueOf(this.uploadId));
        request.addHeader(HttpHeaders.XKssCopySource, ("/" + this.getSourceBucket() + "/" + HttpUtils.urlEncode(this.getSourceObject(), true)).replace("//", "/%2F"));
        String begin = this.beginRange == -1L ? "0" : String.valueOf(this.beginRange);
        String end = this.endRange != -1L ? String.valueOf(this.endRange) : "";
        request.addHeader(HttpHeaders.XKssCopySourceRange, "bytes=" + begin + "-" + end);
        request.getHeaders().putAll(HttpUtils.convertSSECustomerKey2Headers(this.destinationSSECustomerKey));
        request.getHeaders().putAll(HttpUtils.convertCopySourceSSECustomerKey2Headers(this.sourceSSECustomerKey));
        if (this.matchingETagConstraints != null && this.matchingETagConstraints.size() > 0) {
            request.addHeader(HttpHeaders.CopySourceIfMatch, StringUtils.join(this.matchingETagConstraints, ","));
        }
        if (this.nonmatchingEtagConstraints != null && this.nonmatchingEtagConstraints.size() > 0) {
            request.addHeader(HttpHeaders.CopySourceIfNoneMatch, StringUtils.join(this.nonmatchingEtagConstraints, ","));
        }
        if (this.unmodifiedSinceConstraint != null) {
            request.addHeader(HttpHeaders.CopySourceIfUnmodifiedSince, DateUtils.convertDate2Str(this.unmodifiedSinceConstraint, DateUtils.DATETIME_PROTOCOL.RFC1123));
        }
        if (this.modifiedSinceConstraint != null) {
            request.addHeader(HttpHeaders.CopySourceIfModifiedSince, DateUtils.convertDate2Str(this.modifiedSinceConstraint, DateUtils.DATETIME_PROTOCOL.RFC1123));
        }
    }
}

