/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.AccessControlList;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.dto.CreateBucketConfiguration;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.common.BucketType;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;

public class CreateBucketRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private CannedAccessControlList cannedAcl;
    private AccessControlList acl = new AccessControlList();
    private CreateBucketConfiguration config = null;
    private String type;

    public CreateBucketRequest(String bucketName) {
        this.bucket = bucketName;
    }

    public void setBucketType(BucketType type) {
        this.type = type.toString();
    }

    @Deprecated
    public BucketType getBucketType() {
        if (StringUtils.isBlank(this.type)) {
            return null;
        }
        return BucketType.fromValue(this.type);
    }

    public void setType(String bucketType) {
        this.type = bucketType;
    }

    public String getTypeName() {
        return this.type;
    }

    public CreateBucketRequest(String bucketName, CannedAccessControlList cannedAcl) {
        this(bucketName);
        this.setCannedAcl(cannedAcl);
    }

    public CreateBucketRequest(String bucketName, AccessControlList acl) {
        this(bucketName);
        this.setAcl(acl);
    }

    public CreateBucketRequest(String bucketName, CreateBucketConfiguration.REGION region) {
        this(bucketName);
        this.config = new CreateBucketConfiguration(region);
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.validateBucketName(this.bucket) == null) {
            throw ClientIllegalArgumentExceptionGenerator.notCorrect("bucketname", this.bucket, "\u8bf7\u53c2\u8003KS3 API\u6587\u6863");
        }
        if (BucketType.UNKNOWN.toString().equalsIgnoreCase(this.type)) {
            throw new ClientIllegalArgumentException("invalid bucket type: UNKNOWN");
        }
        if (this.config != null && this.config.getLocation() == CreateBucketConfiguration.REGION.UNKNOWN) {
            throw new ClientIllegalArgumentException("invalid region: UNKNOWN");
        }
    }

    public CreateBucketConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CreateBucketConfiguration config) {
        this.config = config;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        if (this.config != null && this.config.getLocation() != null) {
            XmlWriter writer = new XmlWriter();
            writer.startWithNs("CreateBucketConfiguration").start("LocationConstraint").value(this.config.getLocation().toString()).end().end();
            request.setContent(new ByteArrayInputStream(writer.toString().getBytes()));
        }
        if (this.cannedAcl != null) {
            request.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            request.getHeaders().putAll(HttpUtils.convertAcl2Headers(this.acl));
        }
        if (this.type != null) {
            request.getHeaders().put("x-kss-bucket-type", this.type);
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }
}

