/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class ListPartsRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private String uploadId;
    private Integer maxParts = 1000;
    private Integer partNumberMarker;
    private String encodingType;

    public ListPartsRequest(String bucketname, String objectkey, String uploadId) {
        this.bucket = bucketname;
        this.key = objectkey;
        this.uploadId = uploadId;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("uploadId");
        }
        if (this.maxParts != null && (this.maxParts > 1000 || this.maxParts < 1)) {
            throw ClientIllegalArgumentExceptionGenerator.between("maxParts", String.valueOf(this.maxParts), "1", "1000");
        }
        if (this.partNumberMarker != null && (this.partNumberMarker < 0 || this.partNumberMarker >= 10000)) {
            throw ClientIllegalArgumentExceptionGenerator.between("partNumberMarker", String.valueOf(this.partNumberMarker), "0", "9999");
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public Integer getMaxParts() {
        return this.maxParts;
    }

    public void setMaxParts(Integer maxParts) {
        this.maxParts = maxParts;
    }

    public Integer getPartNumberMarker() {
        return this.partNumberMarker;
    }

    public void setPartNumberMarker(Integer partNumberMarker) {
        this.partNumberMarker = partNumberMarker;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        if (this.maxParts != null) {
            request.addQueryParamIfNotNull("max-parts", String.valueOf(this.maxParts));
        }
        request.addQueryParamIfNotNull("uploadId", this.uploadId);
        if (this.partNumberMarker != null && this.partNumberMarker >= 0) {
            request.addQueryParamIfNotNull("part-number-marker", String.valueOf(this.partNumberMarker));
        }
        request.addQueryParamIfNotNull("encoding-type", this.encodingType);
    }
}

