/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public class ProcessObjectRequest
extends Ks3WebServiceRequest {
    private static final String XKSSPROCESS = "x-kss-process";
    private String bucket;
    private String key;
    private String process;

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (StringUtils.isBlank(this.process)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("process");
        }
    }

    public ProcessObjectRequest(String bucket, String key, String process) {
        this.bucket = bucket;
        this.key = key;
        this.process = process;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.POST);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam(XKSSPROCESS, "");
        String xKssProcess = "x-kss-process=" + this.getProcess();
        request.setContent(new ByteArrayInputStream(xKssProcess.getBytes(StandardCharsets.UTF_8)));
    }
}

