/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.Adp;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.URLEncodeUtils;
import java.util.ArrayList;
import java.util.List;

public class PutAdpRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private List<Adp> adps = new ArrayList<Adp>();
    private String notifyURL;

    public PutAdpRequest(String bucketName, String key) {
        this.bucket = bucketName;
        this.key = key;
    }

    public PutAdpRequest(String bucketName, String key, List<Adp> adps) {
        this(bucketName, key);
        this.setAdps(adps);
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectkey");
        }
        if (this.adps == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("adps");
        }
        for (Adp adp : this.adps) {
            if (!StringUtils.isBlank(adp.getCommand())) continue;
            throw ClientIllegalArgumentExceptionGenerator.notNull("adps.command");
        }
        if (StringUtils.isBlank(this.notifyURL)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("notifyURL");
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<Adp> getAdps() {
        return this.adps;
    }

    public void setAdps(List<Adp> adps) {
        this.adps = adps;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.addQueryParam("adp", "");
        request.addHeader(HttpHeaders.AsynchronousProcessingList, URLEncodeUtils.encode(HttpUtils.convertAdps2String(this.adps)));
        if (!StringUtils.isBlank(this.notifyURL)) {
            request.addHeader(HttpHeaders.NotifyURL, HttpUtils.urlEncode(this.notifyURL, false));
        }
    }
}

