/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.BucketCorsConfiguration;
import com.ksyun.ks3.dto.CorsRule;
import com.ksyun.ks3.service.response.Ks3WebServiceXmlResponse;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GetBucketCorsResponse
extends Ks3WebServiceXmlResponse<BucketCorsConfiguration> {
    private CorsRule rule;
    private List<CorsRule.AllowedMethods> allowedMethods;
    private List<String> allowedOrigins;
    private List<String> exposedHeaders;
    private List<String> allowedHeaders;

    @Override
    public int[] expectedStatus() {
        return new int[]{200};
    }

    @Override
    public void preHandle() {
    }

    @Override
    public void startDocument() throws SAXException {
        this.result = new BucketCorsConfiguration();
    }

    @Override
    public void startEle(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("CORSRule".equals(this.getTag())) {
            this.rule = new CorsRule();
            this.allowedMethods = new ArrayList<CorsRule.AllowedMethods>();
            this.allowedOrigins = new ArrayList<String>();
            this.exposedHeaders = new ArrayList<String>();
            this.allowedHeaders = new ArrayList<String>();
        }
    }

    @Override
    public void endEle(String uri, String localName, String qName) throws SAXException {
        if ("CORSRule".equals(this.getTag())) {
            this.rule.setAllowedHeaders(this.allowedHeaders);
            this.rule.setAllowedMethods(this.allowedMethods);
            this.rule.setAllowedOrigins(this.allowedOrigins);
            this.rule.setExposedHeaders(this.exposedHeaders);
            ((BucketCorsConfiguration)this.result).addRule(this.rule);
        }
    }

    @Override
    public void string(String s) {
        if ("MaxAgeSeconds".equals(this.getTag())) {
            this.rule.setMaxAgeSeconds(Integer.parseInt(s));
        } else if ("AllowedHeader".equals(this.getTag())) {
            this.allowedHeaders.add(s);
        } else if ("AllowedMethod".equals(this.getTag())) {
            this.allowedMethods.add(CorsRule.AllowedMethods.load(s));
        } else if ("AllowedOrigin".equals(this.getTag())) {
            this.allowedOrigins.add(s);
        } else if ("ExposeHeader".equals(this.getTag())) {
            this.exposedHeaders.add(s);
        }
    }
}

