/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.RestoreObjectResult;
import com.ksyun.ks3.service.response.Ks3WebServiceDefaultResponse;
import org.apache.http.Header;

public class RestoreObjectResponse
extends Ks3WebServiceDefaultResponse<RestoreObjectResult> {
    @Override
    public void preHandle() {
        this.result = new RestoreObjectResult();
        int statusCode = this.getHttpResponse().getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 202) {
            Header[] headers = this.getHttpResponse().getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].getName().equalsIgnoreCase(Constants.specHeaderPrefix + "storageclass")) continue;
                ((RestoreObjectResult)this.result).setStorageClass(headers[i].getValue());
            }
        }
        switch (statusCode) {
            case 200: {
                ((RestoreObjectResult)this.result).setType(RestoreObjectResult.RestoreCycle.RESTORED);
                break;
            }
            case 202: {
                ((RestoreObjectResult)this.result).setType(RestoreObjectResult.RestoreCycle.RESTORE);
                break;
            }
            case 409: {
                ((RestoreObjectResult)this.result).setType(RestoreObjectResult.RestoreCycle.RESTORING);
                break;
            }
        }
    }

    @Override
    public int[] expectedStatus() {
        return new int[]{200, 202, 409};
    }
}

