/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.utils;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;

public class VersionInfoUtils {
    private static final String VERSION_INFO_FILE = "META-INF/maven/com.ksyun/ks3-kss-java-sdk/pom.properties";
    private static final String USER_AGENT_PREFIX = "ks3-kss-java-sdk";
    private static final String ENCRYPTION_CLIENT_UA_SUFFIX = " ks3EncryptionClient";
    private static String version = null;
    private static String defaultUserAgent = null;
    private static String encryptionClientUserAgent = null;

    public static String getVersion() {
        if (version == null) {
            VersionInfoUtils.initializeVersion();
        }
        return version;
    }

    public static String getDefaultUserAgent() {
        if (defaultUserAgent == null) {
            defaultUserAgent = "ks3-kss-java-sdk/" + VersionInfoUtils.getVersion() + "(" + VersionInfoUtils.getOsAndJdkVersion() + ")";
        }
        return defaultUserAgent;
    }

    public static String getEncryptionUserAgent() {
        if (encryptionClientUserAgent == null) {
            encryptionClientUserAgent = VersionInfoUtils.getDefaultUserAgent() + ENCRYPTION_CLIENT_UA_SUFFIX;
        }
        return encryptionClientUserAgent;
    }

    private static String getOsAndJdkVersion() {
        return System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + ";" + System.getProperty("java.version");
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfoUtils.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new IllegalArgumentException("META-INF/maven/com.ksyun/ks3-kss-java-sdk/pom.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (Exception e) {
            LogFactory.getLog(VersionInfoUtils.class).error((Object)"Unable to load version information for the running SDK: ", (Throwable)e);
            version = "unknown-version";
        }
    }
}

