/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn;

import com.google.gson.Gson;
import com.ksc.HttpMethod;
import com.ksc.cdn.KscClientException;
import com.ksc.cdn.util.AwsSignerV4Util;
import com.ksc.cdn.util.HttpClientUtil;
import com.ksc.cdn.util.HttpResponseCallback;
import com.ksc.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KscApiCommon {
    private String endPoint;
    private String apiRegion;
    private String accessKey;
    private String secretAccessKey;
    private String apiServiceName;
    private static Logger log = LoggerFactory.getLogger(KscApiCommon.class);

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public String getApiRegion() {
        return this.apiRegion;
    }

    public void setApiRegion(String apiRegion) {
        this.apiRegion = apiRegion;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public String getApiServiceName() {
        return this.apiServiceName;
    }

    public void setApiServiceName(String apiServiceName) {
        this.apiServiceName = apiServiceName;
    }

    public Map<String, String> buildHeaders(String version, String action) {
        return this.buildHeaders(version, action, false);
    }

    public Map<String, String> buildHeaders(String version, String action, boolean contentTypeIsJson) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Version", version);
        headers.put("X-Action", action);
        if (contentTypeIsJson) {
            headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        }
        return headers;
    }

    public <T> T httpExecute(HttpMethod method, String url, Object requestContent, Map<String, String> requestHeaders, final Class<T> clazz) throws Exception {
        Object t;
        final String requestUrl = this.endPoint + url;
        URI uri = URI.create(requestUrl);
        Map<Object, Object> awsHeaders = new HashMap();
        switch (method) {
            case GET: {
                awsHeaders = AwsSignerV4Util.getAuthHeaderForGet(uri, (Map)requestContent, requestHeaders, this.apiServiceName, this.apiRegion, this.accessKey, this.secretAccessKey);
                t = HttpClientUtil.get(requestUrl, awsHeaders, (Map)requestContent, new HttpResponseCallback<T>(){

                    @Override
                    public T doResult(CloseableHttpResponse response) throws Exception {
                        return KscApiCommon.this.handleResponse(requestUrl, response, clazz);
                    }
                });
                break;
            }
            case POST: {
                String requestBody;
                String contentType = requestHeaders.get("content-type");
                if (StringUtils.isNotBlank((CharSequence)contentType) && StringUtils.equals((CharSequence)contentType, (CharSequence)ContentType.APPLICATION_JSON.getMimeType())) {
                    requestBody = new Gson().toJson(requestContent);
                    awsHeaders.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
                } else if (StringUtils.isNotBlank((CharSequence)contentType) && StringUtils.equals((CharSequence)contentType, (CharSequence)ContentType.TEXT_XML.getMimeType())) {
                    requestBody = (String)((Map)requestContent).get("body");
                    awsHeaders.put("content-type", ContentType.TEXT_XML.getMimeType());
                } else {
                    requestBody = HttpClientUtil.getUrlEncodedString((Map)requestContent);
                }
                awsHeaders = AwsSignerV4Util.getAuthHeaderForPost(uri, requestBody, requestHeaders, this.apiServiceName, this.apiRegion, this.accessKey, this.secretAccessKey);
                t = HttpClientUtil.post(requestUrl, awsHeaders, requestContent, new HttpResponseCallback<T>(){

                    @Override
                    public T doResult(CloseableHttpResponse response) throws Exception {
                        return KscApiCommon.this.handleResponse(requestUrl, response, clazz);
                    }
                });
                break;
            }
            case DELETE: {
                awsHeaders = AwsSignerV4Util.getAuthHeaderForDelete(uri, (Map)requestContent, requestHeaders, this.apiServiceName, this.apiRegion, this.accessKey, this.secretAccessKey);
                t = HttpClientUtil.delete(requestUrl, awsHeaders, (Map)requestContent, new HttpResponseCallback<T>(){

                    @Override
                    public T doResult(CloseableHttpResponse response) throws Exception {
                        return KscApiCommon.this.handleResponse(requestUrl, response, clazz);
                    }
                });
                break;
            }
            default: {
                throw new KscClientException("Http execute method error. It must be GET or POST or DELETE.");
            }
        }
        return t;
    }

    private <T> T handleResponse(String url, CloseableHttpResponse response, Class<T> clazz) throws Exception {
        int statusCode = response.getStatusLine().getStatusCode();
        String errorCode = "";
        String requestId = "";
        String responseString = "";
        Header[] headers = response.getHeaders("Content-type");
        if (headers.length > 0 && headers[0].getValue().equals("application/xml;charset=UTF-8") && statusCode != 200) {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = response.getEntity().getContent().read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
            if (log.isDebugEnabled()) {
                ByteArrayInputStream copy = new ByteArrayInputStream(baos.toByteArray());
                log.info(IOUtils.toString((InputStream)copy));
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dt = db.parse(inputStream);
            NodeList childNodes = dt.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeName().equals("Error")) {
                    for (int j = 0; j < item.getChildNodes().getLength(); ++j) {
                        if (item.getChildNodes().item(j).getNodeName().equals("Code")) {
                            errorCode = item.getChildNodes().item(j).getTextContent();
                        }
                        if (!item.getChildNodes().item(j).getNodeName().equals("Message")) continue;
                        responseString = item.getChildNodes().item(j).getTextContent();
                    }
                }
                if (!item.getNodeName().equals("RequestId")) continue;
                requestId = item.getTextContent();
            }
            throw new KscClientException(errorCode, responseString, requestId);
        }
        responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
        if (log.isDebugEnabled()) {
            log.info("openAPI url:{}, response code:{}, response content:{}", new Object[]{url, statusCode, responseString});
        }
        if (statusCode == 200 || statusCode == 201) {
            Object t = clazz.equals(String.class) ? responseString : new Gson().fromJson(responseString, clazz);
            return (T)t;
        }
        Map error = (Map)new Gson().fromJson(responseString.toLowerCase(), Map.class);
        errorCode = ((Map)error.get("error")).get("code").toString();
        responseString = ((Map)error.get("error")).get("message").toString();
        requestId = error.get("requestid").toString();
        throw new KscClientException(errorCode, responseString, requestId);
    }
}

