/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn;

import com.ksc.HttpMethod;
import com.ksc.cdn.KscApiCommon;
import com.ksc.cdn.KscCdnBlockUrl;
import com.ksc.cdn.KscCdnContent;
import com.ksc.cdn.KscCdnDomain;
import com.ksc.cdn.KscCdnHttps;
import com.ksc.cdn.KscCdnLog;
import com.ksc.cdn.KscCdnStatistics;
import com.ksc.cdn.KscIpCheck;
import com.ksc.cdn.model.GeneralRequest;
import com.ksc.cdn.model.GeneralRequestParam;
import com.ksc.cdn.model.content.PreloadCachesRequest;
import com.ksc.cdn.model.content.PreloadCachesResult;
import com.ksc.cdn.model.content.RefreshCachesRequest;
import com.ksc.cdn.model.content.RefreshCachesResult;
import com.ksc.cdn.model.content.RefreshOrPreloadQuotaRequest;
import com.ksc.cdn.model.content.RefreshOrPreloadQuotaResult;
import com.ksc.cdn.model.content.RefreshOrPreloadTaskRequest;
import com.ksc.cdn.model.content.RefreshOrPreloadTaskResult;
import com.ksc.cdn.model.domain.blockurl.BlockDomainUrlRequest;
import com.ksc.cdn.model.domain.blockurl.GetBlockUrlQuotaResponse;
import com.ksc.cdn.model.domain.blockurl.GetBlockUrlTaskRequest;
import com.ksc.cdn.model.domain.blockurl.GetBlockUrlTaskResponse;
import com.ksc.cdn.model.domain.createdomain.AddDomainRequest;
import com.ksc.cdn.model.domain.createdomain.AddDomainResult;
import com.ksc.cdn.model.domain.domainbase.GetDomainBaseResult;
import com.ksc.cdn.model.domain.domainbase.ModifyDomainRequest;
import com.ksc.cdn.model.domain.domaincache.CacheConfigRequest;
import com.ksc.cdn.model.domain.domaincollect.GetCdnDomainsRequest;
import com.ksc.cdn.model.domain.domaincollect.GetCdnDomainsResult;
import com.ksc.cdn.model.domain.domaindetail.AllConfigsRequest;
import com.ksc.cdn.model.domain.domaindetail.ErrorPageConfig;
import com.ksc.cdn.model.domain.domaindetail.ForceRedirectConfig;
import com.ksc.cdn.model.domain.domaindetail.GetDomainConfigResult;
import com.ksc.cdn.model.domain.domaindetail.Http2OptionConfig;
import com.ksc.cdn.model.domain.domaindetail.HttpHeadersList;
import com.ksc.cdn.model.domain.domaindetail.IgnoreQueryStringConfig;
import com.ksc.cdn.model.domain.domaindetail.IpProtectionRequest;
import com.ksc.cdn.model.domain.domaindetail.OriginAdvancedConfigRequest;
import com.ksc.cdn.model.domain.domaindetail.PageCompressConfig;
import com.ksc.cdn.model.domain.domaindetail.ReferProtectionRequest;
import com.ksc.cdn.model.domain.domaindetail.RequestAuthConfig;
import com.ksc.cdn.model.domain.domaindetail.VideoSeekConfig;
import com.ksc.cdn.model.domain.domainhttps.HttpsConfCertRequest;
import com.ksc.cdn.model.domain.domainhttps.HttpsGetCertRequest;
import com.ksc.cdn.model.domain.domainhttps.HttpsGetCertResponse;
import com.ksc.cdn.model.domain.domainhttps.HttpsRemoveCertRequest;
import com.ksc.cdn.model.domain.domainhttps.HttpsSetCertRequest;
import com.ksc.cdn.model.domain.ipcheck.IpCheckRequest;
import com.ksc.cdn.model.domain.ipcheck.IpCheckResponse;
import com.ksc.cdn.model.domain.tool.GetCnameSuffixsResult;
import com.ksc.cdn.model.domain.tool.GetDomainsByOriginResult;
import com.ksc.cdn.model.domain.tool.GetServiceIpResult;
import com.ksc.cdn.model.enums.ActionTypeEnum;
import com.ksc.cdn.model.enums.DomainConfigEnum;
import com.ksc.cdn.model.enums.HttpHeaderKeyEnum;
import com.ksc.cdn.model.enums.SwitchEnum;
import com.ksc.cdn.model.log.DomainLogServiceRequest;
import com.ksc.cdn.model.log.DomainLogServiceStatusRequest;
import com.ksc.cdn.model.log.DomainLogServiceStatusResult;
import com.ksc.cdn.model.log.DomainLogsRequest;
import com.ksc.cdn.model.log.DomainLogsResult;
import com.ksc.cdn.model.valid.CommonValidUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KscCdnClient<R>
extends KscApiCommon
implements KscCdnDomain,
KscCdnStatistics,
KscCdnLog,
KscCdnContent,
KscCdnHttps,
KscCdnBlockUrl,
KscIpCheck {
    private static Logger log = LoggerFactory.getLogger(KscCdnClient.class);

    public KscCdnClient() {
    }

    public KscCdnClient(String accessKey, String secretKey) {
        this.setSecretAccessKey(secretKey);
        this.setAccessKey(accessKey);
        this.setEndPoint("http://cdn.api.ksyun.com");
        this.setApiRegion("cn-shanghai-1");
        this.setApiServiceName("cdn");
    }

    public KscCdnClient(String accessKey, String secretKey, String endPoint, String region, String serviceName) {
        this.setSecretAccessKey(secretKey);
        this.setAccessKey(accessKey);
        this.setEndPoint(endPoint);
        this.setApiRegion(region);
        this.setApiServiceName(serviceName);
    }

    @Override
    public GetServiceIpResult getServiceIp(String domainId) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetServiceIpData");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        GetServiceIpResult result = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/GetServiceIpData", params, buildHeaders, GetServiceIpResult.class);
        return result;
    }

    @Override
    public void setDomainConfigs(AllConfigsRequest allConfigs) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetDomainConfigs", true);
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/SetDomainConfigs", allConfigs, buildHeaders, Void.class);
    }

    @Override
    public GetDomainsByOriginResult getDomainsByOrigin(String origin) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetDomainsByOrigin");
        HashMap params = new HashMap();
        GetDomainsByOriginResult result = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/GetDomainsByOrigin", params, buildHeaders, GetDomainsByOriginResult.class);
        return result;
    }

    @Override
    public GetCnameSuffixsResult getCnameSuffixs() throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetCnameSuffixs");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AccountId", "2000001954");
        GetCnameSuffixsResult result = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/GetCnameSuffixs", params, buildHeaders, GetCnameSuffixsResult.class);
        return result;
    }

    @Override
    public GetCdnDomainsResult getCdnDomains(GetCdnDomainsRequest getCdnDomainsRequest) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetCdnDomains");
        GetCdnDomainsResult result = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/GetCdnDomains", getCdnDomainsRequest.buildParams(), buildHeaders, GetCdnDomainsResult.class);
        return result;
    }

    @Override
    public AddDomainResult addDomainBase(AddDomainRequest addDomainRequest) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "AddCdnDomain");
        AddDomainResult addDomainResult = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/AddCdnDomain", addDomainRequest.buildParams(), buildHeaders, AddDomainResult.class);
        return addDomainResult;
    }

    @Override
    public AddDomainResult addDomainV2Base(AddDomainRequest addDomainRequest) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "AddCdnDomain");
        AddDomainResult addDomainResult = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/AddCdnDomain", addDomainRequest.buildParams(), buildHeaders, AddDomainResult.class);
        return addDomainResult;
    }

    @Override
    public GetDomainBaseResult getCdnDomainBasic(String domainId) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetCdnDomainBasicInfo");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        GetDomainBaseResult getDomainBaseResult = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/GetCdnDomainBasicInfo", params, buildHeaders, GetDomainBaseResult.class);
        return getDomainBaseResult;
    }

    @Override
    public void updateDomainBase(ModifyDomainRequest modifyParam) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "ModifyCdnDomainBasicInfo");
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/ModifyCdnDomainBasicInfo", modifyParam.buildParams(), buildHeaders, Void.class);
    }

    @Override
    public void startStopCdnDomain(String domainId, ActionTypeEnum action) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "StartStopCdnDomain");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("ActionType", action.getValue());
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/StartStopCdnDomain", params, buildHeaders, Void.class);
    }

    @Override
    public String deleteCdnDomain(String domainId) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "DeleteCdnDomain");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        String requestId = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/DeleteCdnDomain", params, buildHeaders, String.class);
        return requestId;
    }

    @Override
    public GetDomainConfigResult getDomainConfigs(String domainId, DomainConfigEnum ... configs) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetDomainConfigs");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        StringBuilder configList = new StringBuilder();
        for (DomainConfigEnum conf : configs) {
            configList.append(conf.getValue()).append(",");
        }
        params.put("ConfigList", StringUtils.substringBeforeLast((String)configList.toString(), (String)","));
        GetDomainConfigResult getDomainConfigResult = this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/GetDomainConfigs", params, buildHeaders, GetDomainConfigResult.class);
        return getDomainConfigResult;
    }

    @Override
    public void setIgnoreQueryStringConfig(String domainId, SwitchEnum enable) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetIgnoreQueryStringConfig");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("Enable", enable.getValue());
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/SetIgnoreQueryStringConfig", params, buildHeaders, Void.class);
    }

    @Override
    public void setBackOriginConfig(String domainId, String originHost) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetBackOriginHostConfig");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("BackOriginHost", originHost);
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/SetBackOriginHostConfig", params, buildHeaders, Void.class);
    }

    @Override
    public void setReferProtectionConfig(ReferProtectionRequest referProtection) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetReferProtectionConfig");
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/SetReferProtectionConfig", referProtection.buildParams(), buildHeaders, Void.class);
    }

    @Override
    public void setIpProtectionConfig(IpProtectionRequest ipProtection) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetIpProtectionConfig");
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/SetIpProtectionConfig", ipProtection.buildParams(), buildHeaders, Void.class);
    }

    @Override
    public void setCacheRule(CacheConfigRequest cacheRuleConfig) throws Exception {
        CommonValidUtil.check(cacheRuleConfig);
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetCacheRuleConfig", true);
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/SetCacheRuleConfig", cacheRuleConfig, buildHeaders, Void.class);
    }

    @Override
    public void setTestUrl(String domainId, String testUrl) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("TestUrl", testUrl);
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetTestUrlConfig");
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/SetTestUrlConfig", params, buildHeaders, Void.class);
    }

    @Override
    public void setOriginAdvanced(OriginAdvancedConfigRequest originAdvancedConfig) throws Exception {
        CommonValidUtil.check(originAdvancedConfig);
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetOriginAdvancedConfig", true);
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/SetOriginAdvancedConfig", originAdvancedConfig, buildHeaders, Void.class);
    }

    @Override
    public void setRemark(String domainId, String remark) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("Remark", remark);
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetRemarkConfig");
        this.httpExecute(HttpMethod.GET, "/2016-09-01/domain/SetRemarkConfig", params, buildHeaders, Void.class);
    }

    public R generalGetStatisticsData(GeneralRequest request, Class rType) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction());
        Object result = this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request.buildParams(), buildHeaders, rType);
        return (R)result;
    }

    @Override
    public RefreshCachesResult refreshCaches(RefreshCachesRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, RefreshCachesResult.class);
    }

    @Override
    public PreloadCachesResult preloadCaches(PreloadCachesRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, PreloadCachesResult.class);
    }

    @Override
    public RefreshOrPreloadTaskResult getRefreshOrPreloadTask(RefreshOrPreloadTaskRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, RefreshOrPreloadTaskResult.class);
    }

    @Override
    public RefreshOrPreloadQuotaResult getRefreshOrPreloadQuota(RefreshOrPreloadQuotaRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, RefreshOrPreloadQuotaResult.class);
    }

    @Override
    public DomainLogsResult getDomainLogs(DomainLogsRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, DomainLogsResult.class);
    }

    @Override
    public void setDomainLogService(DomainLogServiceRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request.buildParams(), buildHeaders, Void.class);
    }

    @Override
    public DomainLogServiceStatusResult getDomainLogServiceStatus(DomainLogServiceStatusRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, DomainLogServiceStatusResult.class);
    }

    @Override
    public void blockDomainUrl(BlockDomainUrlRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, Void.class);
    }

    @Override
    public GetBlockUrlTaskResponse getBlockUrlTask(GetBlockUrlTaskRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, GetBlockUrlTaskResponse.class);
    }

    @Override
    public GetBlockUrlQuotaResponse getBlockUrlQuota() throws Exception {
        GeneralRequestParam generalRequestParam = new GeneralRequestParam("GetBlockUrlQuota", "2016-09-01", "/2016-09-01/content/GetBlockUrlQuota");
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.GET, generalRequestParam.getUrl(), new HashMap(), buildHeaders, GetBlockUrlQuotaResponse.class);
    }

    @Override
    public void configCertificate(HttpsConfCertRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, Void.class);
    }

    @Override
    public void setCertificate(HttpsSetCertRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, Void.class);
    }

    @Override
    public void removeCertificates(HttpsRemoveCertRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, Void.class);
    }

    @Override
    public HttpsGetCertResponse getCertificates(HttpsGetCertRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, HttpsGetCertResponse.class);
    }

    private String getDomainByUrl(String url) {
        Pattern p = Pattern.compile("(?<=://|)([^\\s/]+\\.)+[^\\s/:]+", 2);
        Matcher matcher = p.matcher(url);
        matcher.find();
        return matcher.group();
    }

    @Override
    public void setVideoSeekConfig(String domainId, SwitchEnum enable) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetVideoSeekConfig");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("Enable", enable.getValue());
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/SetVideoSeekConfig", params, buildHeaders, Void.class);
    }

    @Override
    public VideoSeekConfig getVideoSeekConfig(String domainId) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetVideoSeekConfig");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        return this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/GetVideoSeekConfig", params, buildHeaders, VideoSeekConfig.class);
    }

    @Override
    public void setHttpHeadersConfig(String domainId, HttpHeaderKeyEnum httpHeaderKeyEnum, String headerValue) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetHttpHeadersConfig");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("HeaderKey", httpHeaderKeyEnum.getValue());
        params.put("HeaderValue", headerValue);
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/SetHttpHeadersConfig", params, buildHeaders, Void.class);
    }

    @Override
    public void deleteHttpHeadersConfig(String domainId, HttpHeaderKeyEnum httpHeaderKeyEnum) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "DeleteHttpHeadersConfig");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        params.put("HeaderKey", httpHeaderKeyEnum.getValue());
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/DeleteHttpHeadersConfig", params, buildHeaders, Void.class);
    }

    @Override
    public HttpHeadersList getHttpHeaderList(String domainId) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "GetHttpHeaderList");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainId", domainId);
        return this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/GetHttpHeaderList", params, buildHeaders, HttpHeadersList.class);
    }

    @Override
    public IpCheckResponse ipCheck(IpCheckRequest request) throws Exception {
        GeneralRequestParam generalRequestParam = request.getGeneralRequestParam();
        Map<String, String> buildHeaders = this.buildHeaders(generalRequestParam.getVersion(), generalRequestParam.getAction(), true);
        return this.httpExecute(HttpMethod.POST, generalRequestParam.getUrl(), request, buildHeaders, IpCheckResponse.class);
    }

    @Override
    public void setRequestAuthConfig(RequestAuthConfig requestAuthConfig) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetRequestAuthConfig", true);
        this.httpExecute(HttpMethod.POST, "/2016-09-01/domain/SetRequestAuthConfig", requestAuthConfig, buildHeaders, Void.class);
    }

    @Override
    public void setForceRedirectConfig(ForceRedirectConfig forceRedirectConfig) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetForceRedirectConfig", true);
        this.httpExecute(HttpMethod.POST, "/", forceRedirectConfig, buildHeaders, Void.class);
    }

    @Override
    public void setHttp2OptionConfig(Http2OptionConfig http2OptionConfig) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetHttp2OptionConfig", true);
        this.httpExecute(HttpMethod.POST, "/", http2OptionConfig, buildHeaders, Void.class);
    }

    @Override
    public void setErrorPageConfig(ErrorPageConfig errorPageConfig) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetErrorPageConfig", true);
        this.httpExecute(HttpMethod.POST, "/", errorPageConfig, buildHeaders, Void.class);
    }

    @Override
    public void setPageCompressConfig(PageCompressConfig pageCompressConfig) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetPageCompressConfig", true);
        this.httpExecute(HttpMethod.POST, "/", pageCompressConfig, buildHeaders, Void.class);
    }

    @Override
    public void setIgnoreQueryStringConfig(IgnoreQueryStringConfig ignoreQueryStringConfig) throws Exception {
        Map<String, String> buildHeaders = this.buildHeaders("2016-09-01", "SetIgnoreQueryStringConfig", true);
        this.httpExecute(HttpMethod.POST, "/", ignoreQueryStringConfig, buildHeaders, Void.class);
    }
}

