/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn.model.statistic;

import com.ksc.cdn.KscClientException;
import com.ksc.cdn.model.GeneralRequest;
import com.ksc.cdn.model.GeneralRequestParam;
import com.ksc.cdn.model.valid.FieldValidate;
import com.ksc.cdn.util.DateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CommonFieldRequest
implements GeneralRequest {
    @FieldValidate
    private String StartTime;
    @FieldValidate
    private String EndTime;
    private String CdnType;
    private String DomainIds;

    public String getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(String startTime) {
        this.StartTime = startTime;
    }

    public String getEndTime() {
        return this.EndTime;
    }

    public void setEndTime(String endTime) {
        this.EndTime = endTime;
    }

    public String getCdnType() {
        return this.CdnType;
    }

    public void setCdnType(String cdnType) {
        this.CdnType = cdnType;
    }

    public String getDomainIds() {
        return this.DomainIds;
    }

    public void setDomainIds(String domainIds) {
        this.DomainIds = domainIds;
    }

    @Override
    public Map<String, String> buildParams() throws KscClientException, ParseException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CdnType", this.getCdnType());
        params.put("StartTime", this.getStartTime());
        params.put("EndTime", this.getEndTime());
        if (StringUtils.isNotBlank((CharSequence)this.getDomainIds())) {
            params.put("DomainIds", this.getDomainIds());
        }
        return params;
    }

    public String getGranularity(String startTime, String endTime) throws ParseException {
        Date startDate = DateUtils.getTimestampByUTCDate(startTime);
        Date endDate = DateUtils.getTimestampByUTCDate(endTime);
        int betweenDay = DateUtils.getDayDiff(startDate, endDate);
        return this.getGranularity(betweenDay);
    }

    private String getGranularity(int betweenDay) {
        if (betweenDay == 0) {
            return "5";
        }
        if (betweenDay < 2) {
            return "10";
        }
        if (betweenDay < 5) {
            return "20";
        }
        if (betweenDay < 15) {
            return "60";
        }
        if (betweenDay < 62) {
            return "240";
        }
        if (betweenDay <= 93) {
            return "480";
        }
        return "";
    }

    @Override
    public GeneralRequestParam getGeneralRequestParam() {
        return null;
    }
}

