/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn.model.valid;

import com.ksc.cdn.KscClientException;
import com.ksc.cdn.model.valid.FieldValidate;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonValidUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonValidUtil.class);

    public static void check(Object object) throws KscClientException {
        Class<?> clazz = object.getClass();
        CommonValidUtil.checkField(clazz, object);
    }

    private static void checkField(Class<? extends Object> clazz, Object object) throws KscClientException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            CommonValidUtil.checkFieldValid(field, object);
        }
        if (clazz.getSuperclass() != null) {
            Class<? extends Object> superclass = clazz.getSuperclass();
            CommonValidUtil.checkField(superclass, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFieldValid(Field field, Object object) throws KscClientException {
        try {
            field.setAccessible(true);
            FieldValidate annotation = field.getAnnotation(FieldValidate.class);
            if (annotation != null && !annotation.nullable()) {
                Object value = field.get(object);
                if (value == null) {
                    throw new KscClientException(String.format("field %s not null", field.getName()));
                }
                if (field.getType() == String.class && StringUtils.isBlank((CharSequence)value.toString())) {
                    throw new KscClientException(String.format("field %s not null", field.getName()));
                }
                if (field.getType() == Integer.class && (Integer)value == 0) {
                    throw new KscClientException(String.format("field %s not 0", field.getName()));
                }
                if (field.getType() == Long.class && (Long)value == 0L) {
                    throw new KscClientException(String.format("field %s not 0", field.getName()));
                }
            }
            if (field.getType() == List.class && field.get(object) != null) {
                List list = (List)field.get(object);
                for (Object li : list) {
                    Field[] declaredFields;
                    for (Field f : declaredFields = li.getClass().getDeclaredFields()) {
                        CommonValidUtil.checkFieldValid(f, li);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            log.warn("validate bean field {} cause illegal access exception", (Object)field.getName());
        }
        finally {
            field.setAccessible(false);
        }
    }
}

