/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn.util;

import com.ksc.DefaultRequest;
import com.ksc.SignableRequest;
import com.ksc.auth.AWS4Signer;
import com.ksc.auth.AWSCredentials;
import com.ksc.auth.BasicAWSCredentials;
import com.ksc.cdn.util.Header;
import com.ksc.http.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AwsSignerV4Util {
    public static Map<String, String> getAuthHeaderForGet(URI uri, Map<String, String> parameters, Map<String, String> headers, String service, String region, String ak, String sk) throws Exception {
        HashMap<String, List<String>> _parameters = new HashMap<String, List<String>>();
        AwsSignerV4Util.filterEmptyParams(_parameters, parameters);
        DefaultRequest request = new DefaultRequest(service);
        request.setHttpMethod(HttpMethodName.GET);
        String scheme = uri.getScheme();
        String beforeAuthority = scheme == null ? "" : scheme + "://";
        String authority = uri.getAuthority();
        String path = uri.getPath();
        request.setEndpoint(URI.create(beforeAuthority + authority));
        request.setResourcePath(path);
        HashMap<String, String> hashMap = headers = headers == null ? new HashMap<String, String>() : headers;
        if (headers.containsKey("X-Amz-Date")) {
            headers.remove("X-Amz-Date");
        }
        if (headers.containsKey("X-KSC-SERVICE")) {
            headers.remove("X-KSC-SERVICE");
        }
        if (headers.containsKey("X-KSC-REGION")) {
            headers.remove("X-KSC-REGION");
        }
        if (headers.containsKey("Authorization")) {
            headers.remove("Authorization");
        }
        request.setHeaders(headers);
        request.setParameters(_parameters);
        request.setContent(null);
        BasicAWSCredentials credentials = new BasicAWSCredentials(ak, sk);
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setServiceName(service);
        aws4Signer.setRegionName(region);
        aws4Signer.sign((SignableRequest)request, (AWSCredentials)credentials);
        headers.put("Authorization", (String)request.getHeaders().get("Authorization"));
        headers.put("X-Amz-Date", (String)request.getHeaders().get("X-Amz-Date"));
        headers.put("X-KSC-SERVICE", service);
        headers.put("X-KSC-REGION", region);
        return headers;
    }

    public static Map<String, String> getAuthHeaderForPost(URI uri, String body, Map<String, String> headers, String service, String region, String ak, String sk) throws Exception {
        DefaultRequest request = new DefaultRequest(service);
        request.setHttpMethod(HttpMethodName.POST);
        String scheme = uri.getScheme();
        String beforeAuthority = scheme == null ? "" : scheme + "://";
        String authority = uri.getAuthority();
        String path = uri.getPath();
        request.setEndpoint(URI.create(beforeAuthority + authority));
        request.setResourcePath(path);
        HashMap<String, String> hashMap = headers = headers == null ? new HashMap<String, String>() : headers;
        if (headers.containsKey("X-Amz-Date")) {
            headers.remove("X-Amz-Date");
        }
        if (headers.containsKey("X-KSC-SERVICE")) {
            headers.remove("X-KSC-SERVICE");
        }
        if (headers.containsKey("X-KSC-REGION")) {
            headers.remove("X-KSC-REGION");
        }
        if (headers.containsKey("Authorization")) {
            headers.remove("Authorization");
        }
        request.setHeaders(headers);
        if (body == null) {
            request.setContent(null);
        } else {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(body.getBytes("UTF-8"));
            request.setContent((InputStream)inputStream);
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(ak, sk);
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setServiceName(service);
        aws4Signer.setRegionName(region);
        aws4Signer.sign((SignableRequest)request, (AWSCredentials)credentials);
        headers.put("Authorization", (String)request.getHeaders().get("Authorization"));
        headers.put("X-Amz-Date", (String)request.getHeaders().get("X-Amz-Date"));
        headers.put("X-KSC-SERVICE", service);
        headers.put("X-KSC-REGION", region);
        return headers;
    }

    public static List<Header> getAuthHeaderForPost(URI uri, Map<String, String> params, InputStream body, Map<String, String> headers, String service, String region, String ak, String sk) throws Exception {
        DefaultRequest request = new DefaultRequest(service);
        request.setHttpMethod(HttpMethodName.POST);
        String scheme = uri.getScheme();
        String beforeAuthority = scheme == null ? "" : scheme + "://";
        String authority = uri.getAuthority();
        String path = uri.getPath();
        request.setEndpoint(URI.create(beforeAuthority + authority));
        request.setResourcePath(path);
        HashMap hashMap = headers = headers == null ? new HashMap() : headers;
        if (headers.containsKey("X-Amz-Date")) {
            headers.remove("X-Amz-Date");
        }
        if (headers.containsKey("X-KSC-SERVICE")) {
            headers.remove("X-KSC-SERVICE");
        }
        if (headers.containsKey("X-KSC-REGION")) {
            headers.remove("X-KSC-REGION");
        }
        if (headers.containsKey("Authorization")) {
            headers.remove("Authorization");
        }
        request.setHeaders(headers);
        request.setContent(body);
        HashMap<String, List<String>> _parameters = new HashMap<String, List<String>>();
        AwsSignerV4Util.filterEmptyParams(_parameters, params);
        request.setParameters(_parameters);
        BasicAWSCredentials credentials = new BasicAWSCredentials(ak, sk);
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setServiceName(service);
        aws4Signer.setRegionName(region);
        aws4Signer.sign((SignableRequest)request, (AWSCredentials)credentials);
        ArrayList<Header> headers2 = new ArrayList<Header>();
        headers2.add(new Header("Authorization", (String)request.getHeaders().get("Authorization")));
        headers2.add(new Header("X-Amz-Date", (String)request.getHeaders().get("X-Amz-Date")));
        headers2.add(new Header("X-KSC-SERVICE", service));
        headers2.add(new Header("X-KSC-REGION", region));
        for (Map.Entry entry : headers.entrySet()) {
            headers2.add(new Header((String)entry.getKey(), (String)entry.getValue()));
        }
        return headers2;
    }

    public static Map<String, String> getAuthHeaderForDelete(URI uri, Map<String, String> parameters, Map<String, String> headers, String service, String region, String ak, String sk) throws Exception {
        HashMap<String, List<String>> _parameters = new HashMap<String, List<String>>();
        AwsSignerV4Util.filterEmptyParams(_parameters, parameters);
        DefaultRequest request = new DefaultRequest(service);
        request.setHttpMethod(HttpMethodName.DELETE);
        String scheme = uri.getScheme();
        String beforeAuthority = scheme == null ? "" : scheme + "://";
        String authority = uri.getAuthority();
        String path = uri.getPath();
        request.setEndpoint(URI.create(beforeAuthority + authority));
        request.setResourcePath(path);
        HashMap<String, String> hashMap = headers = headers == null ? new HashMap<String, String>() : headers;
        if (headers.containsKey("X-Amz-Date")) {
            headers.remove("X-Amz-Date");
        }
        if (headers.containsKey("X-KSC-SERVICE")) {
            headers.remove("X-KSC-SERVICE");
        }
        if (headers.containsKey("X-KSC-REGION")) {
            headers.remove("X-KSC-REGION");
        }
        if (headers.containsKey("Authorization")) {
            headers.remove("Authorization");
        }
        request.setHeaders(headers);
        request.setParameters(_parameters);
        request.setContent(null);
        BasicAWSCredentials credentials = new BasicAWSCredentials(ak, sk);
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setServiceName(service);
        aws4Signer.setRegionName(region);
        aws4Signer.sign((SignableRequest)request, (AWSCredentials)credentials);
        headers.put("Authorization", (String)request.getHeaders().get("Authorization"));
        headers.put("X-Amz-Date", (String)request.getHeaders().get("X-Amz-Date"));
        headers.put("X-KSC-SERVICE", service);
        headers.put("X-KSC-REGION", region);
        return headers;
    }

    public static List<Header> getAuthHeaderForPut(URI uri, String body, Map<String, String> headers, String service, String region, String ak, String sk) throws Exception {
        DefaultRequest request = new DefaultRequest(service);
        request.setHttpMethod(HttpMethodName.PUT);
        String scheme = uri.getScheme();
        String beforeAuthority = scheme == null ? "" : scheme + "://";
        String authority = uri.getAuthority();
        String path = uri.getPath();
        request.setEndpoint(URI.create(beforeAuthority + authority));
        request.setResourcePath(path);
        HashMap hashMap = headers = headers == null ? new HashMap() : headers;
        if (headers.containsKey("X-Amz-Date")) {
            headers.remove("X-Amz-Date");
        }
        if (headers.containsKey("X-KSC-SERVICE")) {
            headers.remove("X-KSC-SERVICE");
        }
        if (headers.containsKey("X-KSC-REGION")) {
            headers.remove("X-KSC-REGION");
        }
        if (headers.containsKey("Authorization")) {
            headers.remove("Authorization");
        }
        request.setHeaders(headers);
        if (body == null) {
            request.setContent(null);
        } else {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(body.getBytes("UTF-8"));
            request.setContent((InputStream)inputStream);
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(ak, sk);
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setServiceName(service);
        aws4Signer.setRegionName(region);
        aws4Signer.sign((SignableRequest)request, (AWSCredentials)credentials);
        ArrayList<Header> headers2 = new ArrayList<Header>();
        headers2.add(new Header("Authorization", (String)request.getHeaders().get("Authorization")));
        headers2.add(new Header("X-Amz-Date", (String)request.getHeaders().get("X-Amz-Date")));
        headers2.add(new Header("X-KSC-SERVICE", service));
        headers2.add(new Header("X-KSC-REGION", region));
        for (Map.Entry entry : headers.entrySet()) {
            headers2.add(new Header((String)entry.getKey(), (String)entry.getValue()));
        }
        return headers2;
    }

    private static void filterEmptyParams(Map<String, List<String>> newParameters, Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            newParameters.put(key, Arrays.asList(value));
        }
    }
}

