/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn.util;

import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATA_TIME_PATTERN_UTC = "yyyy-MM-dd'T'HH:mm+0800";

    public static int getDayDiff(Date date1, Date date2) {
        Date endDate;
        if (date1 == null || date2 == null) {
            throw new InvalidParameterException("date1 and date2 cannot be null!");
        }
        Date startDate = org.apache.commons.lang3.time.DateUtils.truncate((Date)date1, (int)5);
        if (startDate.after(endDate = org.apache.commons.lang3.time.DateUtils.truncate((Date)date2, (int)5))) {
            throw new InvalidParameterException("date1 cannot be after date2!");
        }
        return (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
    }

    public static Date timestamp2Datetime(long timestamp) throws ParseException {
        return DateUtils.timestamp2Datetime(timestamp, DATE_TIME_PATTERN);
    }

    public static Date timestamp2Datetime(long timestamp, String pattern) throws ParseException {
        String dateString = DateFormatUtils.format((long)timestamp, (String)pattern);
        Date date = org.apache.commons.lang3.time.DateUtils.parseDate((String)dateString, (String[])new String[]{pattern});
        return date;
    }

    public static String timestamp2String(long timestamp) {
        return DateUtils.timestamp2String(timestamp, DATE_TIME_PATTERN);
    }

    public static String timestamp2String(long timestamp, String pattern) {
        String dateString = DateFormatUtils.format((long)timestamp, (String)pattern);
        return dateString;
    }

    public static Date getTimestampByUTCDate(String UTCDate) throws ParseException {
        Date date = org.apache.commons.lang3.time.DateUtils.parseDate((String)UTCDate, (String[])new String[]{DATA_TIME_PATTERN_UTC});
        return date;
    }

    public static String utcTime2String(String UTCDate) throws ParseException {
        String date = DateFormatUtils.format((Date)org.apache.commons.lang3.time.DateUtils.parseDate((String)UTCDate, (String[])new String[]{DATA_TIME_PATTERN_UTC}), (String)DATE_TIME_PATTERN);
        return date;
    }
}

