/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.cdn.util;

import com.google.gson.Gson;
import com.ksc.cdn.util.HttpResponseCallback;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static String proxHost;
    private static int proxPort;
    static String proxyArg;
    static String portArg;
    private static final RequestConfig requestConfig;
    private static final int REQUEST_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 60000;
    private static PoolingHttpClientConnectionManager cm;
    private static Logger log;

    public static <T> T get(String url, Map<String, String> headers, Map<String, String> params, HttpResponseCallback<T> responseCallback) throws Exception {
        CloseableHttpResponse response = HttpClientUtil.basicGet(url, headers, params);
        T t = responseCallback.doResult(response);
        HttpClientUtil.closeCloseableHttpResponse(response);
        return t;
    }

    public static <T> T delete(String url, Map<String, String> headers, Map<String, String> params, HttpResponseCallback<T> responseCallback) throws Exception {
        CloseableHttpResponse response = HttpClientUtil.basicDelete(url, headers, params);
        T t = responseCallback.doResult(response);
        HttpClientUtil.closeCloseableHttpResponse(response);
        return t;
    }

    public static <T> T post(String url, Map<String, String> headers, Object params, HttpResponseCallback<T> responseCallback) throws Exception {
        CloseableHttpResponse response = HttpClientUtil.basicPost(url, headers, params);
        T t = responseCallback.doResult(response);
        HttpClientUtil.closeCloseableHttpResponse(response);
        return t;
    }

    public static CloseableHttpResponse basicGet(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        CloseableHttpResponse response;
        try {
            CloseableHttpClient httpClient = HttpClientUtil.createCloseableHttpClient(url);
            URIBuilder builder = new URIBuilder(url);
            if (params != null && params.size() > 0) {
                builder.setParameters(HttpClientUtil.paramsConverter(params));
                log.info("params: " + params);
            }
            HttpGet httpGet = new HttpGet(builder.build());
            log.info("HTTP GET URL: {}", (Object)builder.toString());
            HttpClientUtil.setProxy((HttpRequestBase)httpGet, url);
            httpGet.setHeaders((Header[])HttpClientUtil.headerConverter(headers));
            response = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            log.error("get url:{}, throw exception;{}", (Object)url, (Object)HttpClientUtil.getTrace(e));
            throw e;
        }
        return response;
    }

    public static CloseableHttpResponse basicPost(String url, Map<String, String> headers, Object params) throws Exception {
        CloseableHttpResponse response;
        try {
            UrlEncodedFormEntity param;
            CloseableHttpClient httpClient = HttpClientUtil.createCloseableHttpClient(url);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeaders((Header[])HttpClientUtil.headerConverter(headers));
            if (headers.get("content-type") != null && headers.get("content-type").equals(ContentType.APPLICATION_JSON.getMimeType())) {
                Gson gson = new Gson();
                param = new StringEntity(gson.toJson(params), ContentType.APPLICATION_JSON);
                param.setContentEncoding("UTF-8");
            } else if (headers.get("content-type") != null && headers.get("content-type").equals(ContentType.TEXT_XML.getMimeType())) {
                param = new StringEntity((String)((Map)params).get("body"), ContentType.TEXT_XML);
                param.setContentEncoding("UTF-8");
            } else {
                param = new UrlEncodedFormEntity(HttpClientUtil.paramsConverter((Map)params), "UTF-8");
            }
            httpPost.setEntity((HttpEntity)param);
            HttpClientUtil.setProxy((HttpRequestBase)httpPost, url);
            log.info("HTTP POST URL: {}", (Object)url);
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            log.error("post url:{}, throw exception:{}", (Object)url, (Object)HttpClientUtil.getTrace(e));
            throw e;
        }
        return response;
    }

    public static CloseableHttpResponse basicDelete(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpClientUtil.createCloseableHttpClient(url);
            URIBuilder builder = new URIBuilder(url);
            if (params != null && params.size() > 0) {
                builder.setParameters(HttpClientUtil.paramsConverter(params));
                log.info("params: " + params);
            }
            HttpDelete httpDelete = new HttpDelete(builder.build());
            log.info("HTTP DELETE URL: {}", (Object)builder.toString());
            HttpClientUtil.setProxy((HttpRequestBase)httpDelete, url);
            httpDelete.setHeaders((Header[])HttpClientUtil.headerConverter(headers));
            response = httpClient.execute((HttpUriRequest)httpDelete);
            return response;
        }
        catch (Exception e) {
            log.error("delete url:{}, throw exception:{}", (Object)url, (Object)HttpClientUtil.getTrace(e));
            throw e;
        }
    }

    public static void closeCloseableHttpResponse(CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null) {
            try {
                closeableHttpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error(e.getMessage(), e.getCause());
            }
        }
    }

    public static CloseableHttpClient createCloseableHttpClient(String url) {
        CloseableHttpClient closeableHttpClient = null;
        if (closeableHttpClient == null) {
            closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
            log.info("use proxy url {}", (Object)url);
        }
        return closeableHttpClient;
    }

    public static HttpRequestBase setProxy(HttpRequestBase request, String url) {
        if (proxHost != null) {
            HttpHost proxy = new HttpHost(proxHost, proxPort);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            request.setConfig(config);
        }
        return request;
    }

    private static List<NameValuePair> paramsConverter(Map<String, String> params) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        Set<Map.Entry<String, String>> paramsSet = params.entrySet();
        for (Map.Entry<String, String> paramEntry : paramsSet) {
            if (paramEntry.getValue() == null) continue;
            nvps.add((NameValuePair)new BasicNameValuePair(paramEntry.getKey(), paramEntry.getValue()));
            log.info("request param: \"{}\": \"{}\"", (Object)paramEntry.getKey(), (Object)paramEntry.getValue());
        }
        return nvps;
    }

    private static BasicHeader[] headerConverter(Map<String, String> headers) {
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>(headers.size());
        headerList.add(new BasicHeader("User-Agent", "ksc-cdn-java-sdk"));
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                headerList.add(new BasicHeader(key, val));
                log.info("request header: \"{}\": \"{}\"", (Object)key, (Object)val);
            }
        }
        return headerList.toArray(new BasicHeader[0]);
    }

    public static String getUrlEncodedString(Map<String, String> params) {
        List<NameValuePair> nameValuePairs = HttpClientUtil.paramsConverter(params);
        String urlEncodedString = URLEncodedUtils.format(nameValuePairs, (String)"utf-8");
        return urlEncodedString;
    }

    private static String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = new StringBuffer();
        buffer.append(stringWriter.getBuffer());
        return buffer.toString();
    }

    static {
        proxyArg = System.getProperty("http.proxyHost");
        portArg = System.getProperty("http.proxyPort");
        cm = new PoolingHttpClientConnectionManager();
        log = LoggerFactory.getLogger(HttpClientUtil.class);
        cm.setMaxTotal(10);
        cm.setDefaultMaxPerRoute(5);
        if (StringUtils.isNotBlank((CharSequence)proxyArg) && StringUtils.isNotBlank((CharSequence)portArg) && StringUtils.isNumeric((CharSequence)portArg)) {
            proxHost = proxyArg;
            proxPort = Integer.valueOf(portArg);
        }
        if (proxHost != null) {
            HttpHost proxy = new HttpHost(proxHost, proxPort);
            requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setProxy(proxy).build();
        } else {
            requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
        }
    }
}

