/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.live;

import com.ksc.ClientConfiguration;
import com.ksc.ClientConfigurationFactory;
import com.ksc.KscWebServiceClient;
import com.ksc.KscWebServiceRequest;
import com.ksc.KscWebServiceResponse;
import com.ksc.Request;
import com.ksc.Response;
import com.ksc.auth.AWSCredentials;
import com.ksc.auth.AWSCredentialsProvider;
import com.ksc.auth.DefaultAWSCredentialsProviderChain;
import com.ksc.http.ExecutionContext;
import com.ksc.http.HttpResponseHandler;
import com.ksc.internal.StaticCredentialsProvider;
import com.ksc.live.Live;
import com.ksc.live.model.GetListRequest;
import com.ksc.live.model.LiveResult;
import com.ksc.live.model.transform.GetListRequestMarshaller;
import com.ksc.live.model.transform.LiveResultStaxUnmarshaller;
import com.ksc.metrics.MetricType;
import com.ksc.metrics.RequestMetricCollector;
import com.ksc.protocol.json.JsonClientMetadata;
import com.ksc.protocol.json.JsonErrorResponseMetadata;
import com.ksc.protocol.json.JsonOperationMetadata;
import com.ksc.protocol.json.SdkJsonProtocolFactory;
import com.ksc.transform.Unmarshaller;
import com.ksc.util.CredentialUtils;
import com.ksc.util.KscRequestMetrics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KSCLiveClient
extends KscWebServiceClient
implements Live {
    private AWSCredentialsProvider kscCredentialsProvider;
    private static final String DEFAULT_SIGNING_NAME = "live";
    private static final String DEFAULT_ENDPOINT_PREFIX = "live";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false));
    private static final Log log = LogFactory.getLog(KSCLiveClient.class);

    public KSCLiveClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public KSCLiveClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public KSCLiveClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public KSCLiveClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.kscCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public KSCLiveClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public KSCLiveClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public KSCLiveClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.kscCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.setServiceNameIntern("live");
        this.setEndpointPrefix("live");
        this.setEndpoint("http://live.api.ksyun.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveResult listPubStreamsInfo(GetListRequest liveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(liveRequest);
        KscRequestMetrics kscRequestMetrics = executionContext.getKscRequestMetrics();
        kscRequestMetrics.startEvent((MetricType)KscRequestMetrics.Field.ClientExecuteTime);
        Request<GetListRequest> request = null;
        Response response = null;
        try {
            kscRequestMetrics.startEvent((MetricType)KscRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetListRequestMarshaller().marshall((GetListRequest)super.beforeMarshalling((KscWebServiceRequest)liveRequest));
                request.setKscRequestMetrics(kscRequestMetrics);
            }
            finally {
                kscRequestMetrics.endEvent((MetricType)KscRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new LiveResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            LiveResult liveResult = (LiveResult)response.getKscResponse();
            return liveResult;
        }
        finally {
            this.endClientExecution(kscRequestMetrics, request, response);
        }
    }

    private <X, Y extends KscWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<KscWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((KscWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.kscCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends KscWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<KscWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        try {
            return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

