/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.live.model.transform;

import com.ksc.DefaultRequest;
import com.ksc.KscClientException;
import com.ksc.KscWebServiceRequest;
import com.ksc.Request;
import com.ksc.http.HttpMethodName;
import com.ksc.live.model.GetListRequest;
import com.ksc.transform.Marshaller;
import org.apache.commons.lang.StringUtils;

public class GetListRequestMarshaller
implements Marshaller<Request<GetListRequest>, GetListRequest> {
    private static GetListRequestMarshaller instance;

    public static GetListRequestMarshaller getInstance() {
        if (instance == null) {
            instance = new GetListRequestMarshaller();
        }
        return instance;
    }

    public Request<GetListRequest> marshall(GetListRequest liveRequest) {
        if (liveRequest == null) {
            throw new KscClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((KscWebServiceRequest)liveRequest, "live");
        request.addParameter("Action", "listPubStreamsInfo");
        String version = liveRequest.getVersion();
        if (StringUtils.isBlank((String)version)) {
            version = "2016-10-26";
        }
        request.addParameter("Version", version);
        request.addParameter("uniquename", liveRequest.getUniquename());
        if (liveRequest.getMarker() != 0) {
            request.addParameter("marker", com.ksc.util.StringUtils.fromInteger((Integer)liveRequest.getMarker()));
        }
        if (liveRequest.getLimit() != 0) {
            request.addParameter("limit", com.ksc.util.StringUtils.fromInteger((Integer)liveRequest.getLimit()));
        }
        if (liveRequest.getApp() != null && liveRequest.getPubdomain() == null) {
            request.addParameter("app", liveRequest.getApp());
        }
        if (liveRequest.getPubdomain() != null && liveRequest.getApp() == null) {
            request.addParameter("pubdomain", liveRequest.getPubdomain());
        }
        request.setHttpMethod(HttpMethodName.GET);
        return request;
    }
}

