/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

import com.kumuluz.ee.common.config.DataSourcePoolConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataSourceConfig {
    private String jndiName;
    private String driverClass;
    private String dataSourceClass;
    private String connectionUrl;
    private String username;
    private String password;
    private DataSourcePoolConfig pool;
    private Map<String, String> props;

    private DataSourceConfig() {
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getDataSourceClass() {
        return this.dataSourceClass;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourcePoolConfig getPool() {
        return this.pool;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public static class Builder {
        private String jndiName;
        private String driverClass;
        private String dataSourceClass;
        private String connectionUrl;
        private String username;
        private String password;
        private DataSourcePoolConfig.Builder pool = new DataSourcePoolConfig.Builder();
        private Map<String, String> props = new HashMap<String, String>();

        public Builder jndiName(String jndiName) {
            this.jndiName = jndiName;
            return this;
        }

        public Builder driverClass(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public Builder dataSourceClass(String dataSourceClass) {
            this.dataSourceClass = dataSourceClass;
            return this;
        }

        public Builder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder pool(DataSourcePoolConfig.Builder pool) {
            this.pool = pool;
            return this;
        }

        public Builder prop(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public DataSourceConfig build() {
            DataSourceConfig dataSourceConfig = new DataSourceConfig();
            dataSourceConfig.jndiName = this.jndiName;
            dataSourceConfig.driverClass = this.driverClass;
            dataSourceConfig.dataSourceClass = this.dataSourceClass;
            dataSourceConfig.connectionUrl = this.connectionUrl;
            dataSourceConfig.username = this.username;
            dataSourceConfig.password = this.password;
            dataSourceConfig.pool = this.pool.build();
            dataSourceConfig.props = Collections.unmodifiableMap(this.props);
            return dataSourceConfig;
        }
    }
}

