/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

import com.kumuluz.ee.common.config.DataSourceConfig;
import com.kumuluz.ee.common.config.DevConfig;
import com.kumuluz.ee.common.config.EnvConfig;
import com.kumuluz.ee.common.config.MailSessionConfig;
import com.kumuluz.ee.common.config.ServerConfig;
import com.kumuluz.ee.common.config.XaDataSourceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class EeConfig {
    private static EeConfig instance;
    private String name;
    private String version;
    private Boolean debug;
    private EnvConfig env;
    private DevConfig dev;
    private ServerConfig server;
    private List<DataSourceConfig> datasources;
    private List<XaDataSourceConfig> xaDatasources;
    private List<MailSessionConfig> mailSessions;

    private EeConfig() {
    }

    public static void initialize(EeConfig eeConfig) {
        if (instance != null) {
            throw new IllegalStateException("The EeConfig was already initialized.");
        }
        instance = eeConfig;
    }

    public static EeConfig getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The EeConfig was not yet initialized.");
        }
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public EnvConfig getEnv() {
        return this.env;
    }

    public DevConfig getDev() {
        return this.dev;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public List<DataSourceConfig> getDatasources() {
        return this.datasources;
    }

    public List<XaDataSourceConfig> getXaDatasources() {
        return this.xaDatasources;
    }

    public List<MailSessionConfig> getMailSessions() {
        return this.mailSessions;
    }

    public static class Builder {
        private String name;
        private String version = "1.0.0";
        private Boolean debug = false;
        private EnvConfig.Builder env = new EnvConfig.Builder();
        private DevConfig.Builder dev = new DevConfig.Builder();
        private ServerConfig.Builder server = new ServerConfig.Builder();
        private List<DataSourceConfig.Builder> datasources = new ArrayList<DataSourceConfig.Builder>();
        private List<XaDataSourceConfig.Builder> xaDatasources = new ArrayList<XaDataSourceConfig.Builder>();
        private List<MailSessionConfig.Builder> mailSessions = new ArrayList<MailSessionConfig.Builder>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder env(EnvConfig.Builder env) {
            this.env = env;
            return this;
        }

        public Builder dev(DevConfig.Builder dev) {
            this.dev = dev;
            return this;
        }

        public Builder server(ServerConfig.Builder server) {
            this.server = server;
            return this;
        }

        public Builder datasource(DataSourceConfig.Builder datasource) {
            this.datasources.add(datasource);
            return this;
        }

        public Builder xaDatasource(XaDataSourceConfig.Builder xaDatasource) {
            this.xaDatasources.add(xaDatasource);
            return this;
        }

        public Builder mailSession(MailSessionConfig.Builder mailSession) {
            this.mailSessions.add(mailSession);
            return this;
        }

        public EeConfig build() {
            List constructedDatasources = this.datasources.stream().map(DataSourceConfig.Builder::build).collect(Collectors.toList());
            List constructedXaDatasources = this.xaDatasources.stream().map(XaDataSourceConfig.Builder::build).collect(Collectors.toList());
            List constructedMailSessions = this.mailSessions.stream().map(MailSessionConfig.Builder::build).collect(Collectors.toList());
            EeConfig eeConfig = new EeConfig();
            eeConfig.name = this.name;
            eeConfig.version = this.version;
            eeConfig.debug = this.debug;
            eeConfig.env = this.env.build();
            eeConfig.dev = this.dev.build();
            eeConfig.server = this.server.build();
            eeConfig.datasources = Collections.unmodifiableList(constructedDatasources);
            eeConfig.xaDatasources = Collections.unmodifiableList(constructedXaDatasources);
            eeConfig.mailSessions = Collections.unmodifiableList(constructedMailSessions);
            return eeConfig;
        }
    }
}

