/*
 * Decompiled with CFR 0.152.
 */
package com.kumuluz.ee.common.config;

import com.kumuluz.ee.common.config.GzipConfig;
import com.kumuluz.ee.common.config.ServerConnectorConfig;

public class ServerConfig {
    private String baseUrl;
    private String contextPath;
    private Boolean dirBrowsing;
    private Boolean etags;
    private Integer minThreads;
    private Integer maxThreads;
    private Boolean forceHttps;
    private Boolean showServerInfo;
    private Boolean forwardStartupException;
    private ServerConnectorConfig http;
    private ServerConnectorConfig https;
    private GzipConfig gzip;

    private ServerConfig() {
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Boolean getDirBrowsing() {
        return this.dirBrowsing;
    }

    public Boolean getEtags() {
        return this.etags;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public Boolean getForceHttps() {
        return this.forceHttps;
    }

    public Boolean getShowServerInfo() {
        return this.showServerInfo;
    }

    public Boolean getForwardStartupException() {
        return this.forwardStartupException;
    }

    public ServerConnectorConfig getHttp() {
        return this.http;
    }

    public ServerConnectorConfig getHttps() {
        return this.https;
    }

    public GzipConfig getGzip() {
        return this.gzip;
    }

    public static class Builder {
        private String baseUrl;
        private String contextPath = "/";
        private Boolean dirBrowsing = false;
        private Boolean etags = false;
        private Integer minThreads = 5;
        private Integer maxThreads = 100;
        private Boolean forceHttps = false;
        private Boolean showServerInfo = true;
        private Boolean forwardStartupException;
        private ServerConnectorConfig.Builder http = new ServerConnectorConfig.Builder();
        private ServerConnectorConfig.Builder https;
        private GzipConfig.Builder gzip;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder dirBrowsing(Boolean dirBrowsing) {
            this.dirBrowsing = dirBrowsing;
            return this;
        }

        public Builder etags(Boolean etags) {
            this.etags = etags;
            return this;
        }

        public Builder minThreads(Integer minThreads) {
            this.minThreads = minThreads;
            return this;
        }

        public Builder maxThreads(Integer maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder forceHttps(Boolean forceHttps) {
            this.forceHttps = forceHttps;
            return this;
        }

        public Builder http(ServerConnectorConfig.Builder http) {
            this.http = http;
            return this;
        }

        public Builder https(ServerConnectorConfig.Builder https) {
            this.https = https;
            return this;
        }

        public Builder gzip(GzipConfig.Builder gzip) {
            this.gzip = gzip;
            return this;
        }

        public Builder showServerInfo(Boolean showServerInfo) {
            this.showServerInfo = showServerInfo;
            return this;
        }

        public Builder forwardStartupException(Boolean forwardStartupException) {
            this.forwardStartupException = forwardStartupException;
            return this;
        }

        public ServerConfig build() {
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.baseUrl = this.baseUrl;
            serverConfig.contextPath = this.contextPath;
            serverConfig.dirBrowsing = this.dirBrowsing;
            serverConfig.etags = this.etags;
            serverConfig.minThreads = this.minThreads;
            serverConfig.maxThreads = this.maxThreads;
            serverConfig.forceHttps = this.forceHttps;
            serverConfig.showServerInfo = this.showServerInfo;
            serverConfig.forwardStartupException = this.forwardStartupException;
            serverConfig.http = this.http.build();
            if (this.https != null) {
                serverConfig.https = this.https.build();
            }
            if (this.gzip != null) {
                serverConfig.gzip = this.gzip.build();
            }
            return serverConfig;
        }
    }
}

